/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.ruta.ide.parser.ast;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.antlr.runtime.Token;
import org.apache.commons.lang3.StringUtils;
import org.apache.uima.ruta.ide.parser.ast.AbstractFactory;
import org.apache.uima.ruta.ide.parser.ast.ComposedRuleElement;
import org.apache.uima.ruta.ide.parser.ast.ForEachBlock;
import org.apache.uima.ruta.ide.parser.ast.RutaAction;
import org.apache.uima.ruta.ide.parser.ast.RutaBlock;
import org.apache.uima.ruta.ide.parser.ast.RutaCondition;
import org.apache.uima.ruta.ide.parser.ast.RutaRegExpRule;
import org.apache.uima.ruta.ide.parser.ast.RutaRule;
import org.apache.uima.ruta.ide.parser.ast.RutaRuleElement;
import org.apache.uima.ruta.ide.parser.ast.RutaScriptBlock;
import org.eclipse.dltk.ast.ASTNode;
import org.eclipse.dltk.ast.expressions.Expression;
import org.eclipse.dltk.ast.statements.Block;
import org.eclipse.dltk.ast.statements.Statement;

public class ScriptFactory
extends AbstractFactory {
    private int idCounter;

    public void resetRuleCounter() {
        this.idCounter = 0;
    }

    public RutaRule createRule(RutaRuleElement element) {
        ArrayList<Expression> elements = new ArrayList<Expression>();
        elements.add(element);
        return this.createRule(elements, null);
    }

    public RutaRule createImplicitRule(List<RutaAction> actions, Token end) {
        ArrayList<Expression> elements = new ArrayList<Expression>();
        RutaRuleElement element = this.createRuleElement(null, null, null, actions, end);
        if (actions != null && !actions.isEmpty()) {
            element.setStart(actions.get(0).sourceStart());
        }
        elements.add(element);
        return this.createRule(elements, null);
    }

    public RutaRule createRule(List<Expression> elements, Token s, boolean updateCounter) {
        RutaRule rule = new RutaRule(elements, this.idCounter);
        if (updateCounter) {
            ++this.idCounter;
        }
        if (s != null) {
            int[] bounds = ScriptFactory.getBounds(s);
            rule.setEnd(bounds[1]);
        }
        return rule;
    }

    public RutaRule createRule(List<Expression> elements, Token s) {
        return this.createRule(elements, s, true);
    }

    public RutaRule createRegExpRule(List<Expression> exprs, Map<Expression, Map<Expression, Expression>> fa, Token s) {
        return this.createRegExpRule(exprs, fa, s, false);
    }

    public RutaRule createRegExpRule(List<Expression> exprs, Map<Expression, Map<Expression, Expression>> fa, Token s, boolean updateCounter) {
        ArrayList<Expression> expressions = new ArrayList<Expression>();
        for (Expression each : exprs) {
            if (each == null) continue;
            expressions.add(each);
            Collection<Map<Expression, Expression>> values = fa.values();
            for (Map<Expression, Expression> map : values) {
                Set<Map.Entry<Expression, Expression>> entrySet = map.entrySet();
                for (Map.Entry<Expression, Expression> entry : entrySet) {
                    expressions.add(entry.getKey());
                    expressions.add(entry.getValue());
                }
            }
        }
        RutaRegExpRule rule = new RutaRegExpRule(expressions, fa, this.idCounter);
        if (updateCounter) {
            ++this.idCounter;
        }
        if (s != null) {
            int[] bounds = ScriptFactory.getBounds(s);
            rule.setEnd(bounds[1]);
        }
        return rule;
    }

    public ComposedRuleElement createComposedRuleElement(List<Expression> res, List<Expression> q, List<RutaCondition> c, List<RutaAction> a, Boolean disjunctive, RutaBlock env, Token ... tokens) {
        int[] bounds = ScriptFactory.getSurroundingBounds(null, res);
        this.filterNullObjects(res);
        this.filterNullObjects(q);
        this.filterNullObjects(c);
        this.filterNullObjects(a);
        ASTNode quantifierPart = null;
        if (q != null && !q.isEmpty()) {
            quantifierPart = (ASTNode)q.get(q.size() - 1);
        }
        if (quantifierPart != null) {
            bounds[1] = Math.max(bounds[1], quantifierPart.sourceEnd());
        }
        if (c != null && !c.isEmpty()) {
            bounds[1] = Math.max(bounds[1], c.get(c.size() - 1).sourceEnd());
        }
        if (a != null && !a.isEmpty()) {
            bounds[1] = Math.max(bounds[1], a.get(a.size() - 1).sourceEnd());
        }
        if (tokens != null && tokens.length > 0) {
            bounds[0] = Math.min(bounds[0], ScriptFactory.getBounds(tokens[0])[0]);
        }
        if (tokens != null && tokens.length == 2 && tokens[1] != null) {
            bounds[1] = Math.max(bounds[1], ScriptFactory.getBounds(tokens[1])[1]);
        }
        if (tokens != null && tokens.length == 3 && tokens[2] != null) {
            bounds[1] = Math.max(bounds[1], ScriptFactory.getBounds(tokens[2])[1]);
        }
        return new ComposedRuleElement(bounds[0], bounds[1], res, q, c, a, disjunctive);
    }

    public RutaRuleElement createRuleElement(Expression head, List<Expression> quantifierPartExpressions, List<RutaCondition> conditions, List<RutaAction> actions, Token end) {
        int[] bounds = ScriptFactory.getSurroundingBounds((ASTNode)head, conditions, actions);
        ScriptFactory.setMaxEnd(bounds, end);
        this.filterNullObjects(quantifierPartExpressions);
        this.filterNullObjects(conditions);
        this.filterNullObjects(actions);
        ASTNode quantifierPart = null;
        if (quantifierPartExpressions != null && !quantifierPartExpressions.isEmpty()) {
            quantifierPart = (ASTNode)quantifierPartExpressions.get(quantifierPartExpressions.size() - 1);
        }
        if (quantifierPart != null) {
            bounds[1] = Math.max(bounds[1], quantifierPart.sourceEnd());
        }
        return new RutaRuleElement(bounds[0], bounds[1], head, quantifierPartExpressions, conditions, actions);
    }

    public RutaRuleElement createRuleElement(Token w, List<RutaCondition> c, List<RutaAction> a, Token end) {
        int[] bounds = ScriptFactory.getSurroundingBounds(null, c, a);
        ScriptFactory.setMinBegin(bounds, w);
        this.filterNullObjects(c);
        this.filterNullObjects(a);
        RutaRuleElement rutaRuleElement = new RutaRuleElement(bounds[0], bounds[1], null, null, c, a);
        if (w != null && w.getText().equals("#")) {
            rutaRuleElement.setWildcard(true);
        }
        return rutaRuleElement;
    }

    public RutaScriptBlock createScriptBlock(int declStart, int declEnd, int nameStart, int nameEnd, String string, List<RutaRuleElement> res, Block block, String packageString) {
        this.createRule(new ArrayList<Expression>(), null);
        return new RutaScriptBlock(string, packageString, nameStart, nameEnd, declStart, declEnd);
    }

    public RutaBlock createScriptBlock(Token id, Token type, RutaBlock rutaBlock) {
        boolean forEach = false;
        if (type != null) {
            forEach = StringUtils.equals((CharSequence)type.getText(), (CharSequence)"FOREACH");
        }
        int[] bounds = ScriptFactory.getBounds(type, id);
        int[] nameBounds = ScriptFactory.getBounds(id);
        RutaBlock block = null;
        if (rutaBlock == null) {
            block = forEach ? new ForEachBlock(id.getText(), "error", nameBounds[0], nameBounds[1], bounds[0], bounds[1]) : new RutaScriptBlock(id.getText(), "error", nameBounds[0], nameBounds[1], bounds[0], bounds[1]);
            return block;
        }
        block = forEach ? new ForEachBlock(id.getText(), rutaBlock.getNamespace(), nameBounds[0], nameBounds[1], bounds[0], bounds[1]) : new RutaScriptBlock(id.getText(), rutaBlock.getNamespace(), nameBounds[0], nameBounds[1], bounds[0], bounds[1]);
        return block;
    }

    public RutaBlock createExternalBlock(Token type, RutaBlock parent) {
        int[] bounds = ScriptFactory.getBounds(type);
        int[] nameBounds = ScriptFactory.getBounds(type);
        RutaBlock block = new RutaBlock(type.getText(), type.getText(), nameBounds[0], nameBounds[1], bounds[0], bounds[1]);
        return block;
    }

    public void finalizeBlock(RutaBlock block, Token rc, RutaRule rule, List<Statement> body) {
        this.filterNullObjects(body);
        int innerStart = 0;
        int innerEnd = 0;
        ArrayList<Statement> list = new ArrayList<Statement>();
        if (body != null && !body.isEmpty()) {
            innerStart = body.get(0).sourceStart();
            innerEnd = body.get(body.size() - 1).sourceEnd();
            list.addAll(body);
        }
        Block inner = new Block(innerStart, innerEnd, list);
        block.acceptBody(inner, false);
        block.setRule(rule);
        block.setEnd(rc != null ? ScriptFactory.getBounds(rc)[1] : rule.sourceEnd());
    }

    private void filterNullObjects(List<?> body) {
        if (body == null) {
            return;
        }
        for (int i = 0; i < body.size(); ++i) {
            Object obj = body.get(i);
            if (obj != null) continue;
            body.remove(i);
            --i;
        }
    }
}

