/*
 * Decompiled with CFR 0.152.
 */
package org.pac4j.cas.client.direct;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.pac4j.cas.authorization.DefaultCasAuthorizationGenerator;
import org.pac4j.cas.config.CasConfiguration;
import org.pac4j.cas.credentials.authenticator.CasAuthenticator;
import org.pac4j.cas.redirect.CasRedirectionActionBuilder;
import org.pac4j.core.client.DirectClient;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.context.WebContext;
import org.pac4j.core.credentials.Credentials;
import org.pac4j.core.credentials.authenticator.Authenticator;
import org.pac4j.core.credentials.extractor.CredentialsExtractor;
import org.pac4j.core.credentials.extractor.ParameterExtractor;
import org.pac4j.core.exception.CredentialsException;
import org.pac4j.core.exception.TechnicalException;
import org.pac4j.core.http.callback.CallbackUrlResolver;
import org.pac4j.core.http.callback.NoParameterCallbackUrlResolver;
import org.pac4j.core.http.url.DefaultUrlResolver;
import org.pac4j.core.http.url.UrlResolver;
import org.pac4j.core.util.CommonHelper;
import org.pac4j.core.util.HttpActionHelper;

public class DirectCasClient
extends DirectClient {
    private CasConfiguration configuration;
    private UrlResolver urlResolver = new DefaultUrlResolver();
    private CallbackUrlResolver callbackUrlResolver = new NoParameterCallbackUrlResolver();

    public DirectCasClient() {
    }

    public DirectCasClient(CasConfiguration casConfiguration) {
        this.configuration = casConfiguration;
    }

    protected void internalInit(boolean forceReinits) {
        CommonHelper.assertNotNull((String)"configuration", (Object)((Object)this.configuration));
        CommonHelper.assertTrue((!this.configuration.isGateway() ? 1 : 0) != 0, (String)"the DirectCasClient can not support gateway to avoid infinite loops");
        this.setCredentialsExtractorIfUndefined((CredentialsExtractor)new ParameterExtractor("ticket", true, false));
        super.setAuthenticatorIfUndefined((Authenticator)new CasAuthenticator(this.configuration, this.getName(), this.urlResolver, this.callbackUrlResolver, "fake", this.findSessionLogoutHandler()));
        this.addAuthorizationGenerator(new DefaultCasAuthorizationGenerator());
    }

    public Optional<Credentials> getCredentials(CallContext ctx) {
        this.init();
        WebContext webContext = ctx.webContext();
        try {
            String callbackUrl = this.callbackUrlResolver.compute(this.urlResolver, webContext.getFullRequestURL(), this.getName(), webContext);
            String loginUrl = this.configuration.computeFinalLoginUrl(webContext);
            Optional credentials = this.getCredentialsExtractor().extract(ctx);
            if (credentials.isEmpty()) {
                String redirectionUrl = CasRedirectionActionBuilder.constructRedirectUrl(loginUrl, "service", callbackUrl, this.configuration.isRenew(), false, null);
                this.logger.debug("redirectionUrl: {}", (Object)redirectionUrl);
                throw HttpActionHelper.buildRedirectUrlAction((WebContext)webContext, (String)redirectionUrl);
            }
            return credentials;
        }
        catch (CredentialsException e) {
            this.logger.error("Failed to retrieve CAS credentials", (Throwable)e);
            return Optional.empty();
        }
    }

    protected Optional<Credentials> internalValidateCredentials(CallContext ctx, Credentials credentials) {
        WebContext webContext = ctx.webContext();
        try {
            String callbackUrl = this.callbackUrlResolver.compute(this.urlResolver, webContext.getFullRequestURL(), this.getName(), webContext);
            callbackUrl = StringUtils.substringBefore((String)callbackUrl, (String)"?ticket=");
            callbackUrl = StringUtils.substringBefore((String)callbackUrl, (String)"&ticket=");
            CasAuthenticator casAuthenticator = new CasAuthenticator(this.configuration, this.getName(), this.urlResolver, this.callbackUrlResolver, callbackUrl, this.findSessionLogoutHandler());
            casAuthenticator.init();
            casAuthenticator.validate(ctx, credentials);
            return Optional.of(credentials);
        }
        catch (CredentialsException e) {
            this.logger.error("Failed to validate CAS credentials", (Throwable)e);
            return Optional.empty();
        }
    }

    protected void setAuthenticatorIfUndefined(Authenticator authenticator) {
        throw new TechnicalException("You can not set an Authenticator for the DirectCasClient at startup. A new CasAuthenticator is automatically created for each request");
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public String toString() {
        return "DirectCasClient(super=" + super.toString() + ", configuration=" + this.configuration + ", urlResolver=" + this.urlResolver + ", callbackUrlResolver=" + this.callbackUrlResolver + ")";
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CasConfiguration getConfiguration() {
        return this.configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public UrlResolver getUrlResolver() {
        return this.urlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public CallbackUrlResolver getCallbackUrlResolver() {
        return this.callbackUrlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setConfiguration(CasConfiguration configuration) {
        this.configuration = configuration;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setUrlResolver(UrlResolver urlResolver) {
        this.urlResolver = urlResolver;
    }

    @SuppressFBWarnings(justification="generated code")
    @Generated
    public void setCallbackUrlResolver(CallbackUrlResolver callbackUrlResolver) {
        this.callbackUrlResolver = callbackUrlResolver;
    }
}

