/*
 * Decompiled with CFR 0.152.
 */
package org.flowable.idm.engine.test;

import java.util.function.Consumer;
import org.flowable.idm.engine.IdmEngine;
import org.flowable.idm.engine.IdmEngineConfiguration;
import org.flowable.idm.engine.IdmEngines;
import org.flowable.idm.engine.test.InternalFlowableIdmExtension;
import org.junit.jupiter.api.extension.ExtensionContext;

public class ResourceFlowableIdmExtension
extends InternalFlowableIdmExtension {
    private static final ExtensionContext.Namespace NAMESPACE = ExtensionContext.Namespace.create((Object[])new Object[]{ResourceFlowableIdmExtension.class});
    protected final String configurationResource;
    protected final String idmEngineName;
    protected final Consumer<IdmEngineConfiguration> configurationConsumer;

    public ResourceFlowableIdmExtension(String configurationResource, Consumer<IdmEngineConfiguration> configurationConsumer) {
        this(configurationResource, null, configurationConsumer);
    }

    public ResourceFlowableIdmExtension(String configurationResource, String idmEngineName, Consumer<IdmEngineConfiguration> configurationConsumer) {
        this.configurationResource = configurationResource;
        this.idmEngineName = idmEngineName;
        this.configurationConsumer = configurationConsumer;
    }

    @Override
    public void afterEach(ExtensionContext context) throws Exception {
        super.afterEach(context);
        IdmEngine processEngine = this.getIdmEngine(context);
        IdmEngines.unregister(processEngine);
    }

    @Override
    protected IdmEngine getIdmEngine(ExtensionContext context) {
        return (IdmEngine)this.getStore(context).getOrComputeIfAbsent((Object)context.getUniqueId(), key -> this.initializeIdmEngine(), IdmEngine.class);
    }

    protected IdmEngine initializeIdmEngine() {
        IdmEngineConfiguration config = IdmEngineConfiguration.createIdmEngineConfigurationFromResource(this.configurationResource);
        if (this.idmEngineName != null) {
            this.logger.info("Initializing idm engine with name '{}'", (Object)this.idmEngineName);
            config.setEngineName(this.idmEngineName);
        }
        this.configurationConsumer.accept(config);
        IdmEngine idmEngine = config.buildIdmEngine();
        IdmEngines.setInitialized(true);
        return idmEngine;
    }

    @Override
    protected ExtensionContext.Store getStore(ExtensionContext context) {
        return context.getRoot().getStore(NAMESPACE);
    }
}

