/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web.response.accesstoken.response;

import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.oauth2.sdk.auth.X509CertificateConfirmation;
import com.nimbusds.oauth2.sdk.dpop.JWKThumbprintConfirmation;
import java.time.ZonedDateTime;
import java.time.chrono.ChronoZonedDateTime;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.model.support.oauth.OAuthAccessTokenProperties;
import org.apereo.cas.configuration.model.support.oauth.OAuthProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.support.oauth.services.OAuthRegisteredService;
import org.apereo.cas.support.oauth.web.endpoints.OAuth20ConfigurationContext;
import org.apereo.cas.ticket.OAuth20Token;
import org.apereo.cas.ticket.accesstoken.OAuth20AccessToken;
import org.apereo.cas.ticket.refreshtoken.OAuth20RefreshToken;
import org.apereo.cas.token.JwtBuilder;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.crypto.EncodableCipher;
import org.apereo.cas.util.function.FunctionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class OAuth20JwtAccessTokenEncodableCipher
implements EncodableCipher<String, String> {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20JwtAccessTokenEncodableCipher.class);
    private final OAuth20ConfigurationContext configurationContext;
    private final RegisteredService registeredService;
    private final OAuth20Token token;
    private final Service service;
    private final String issuer;
    private final boolean forceEncodeAsJwt;
    private String tokenAudience;

    public String encode(String value, Object[] parameters) {
        if (this.registeredService instanceof OAuthRegisteredService && this.shouldEncodeAsJwt()) {
            return (String)FunctionUtils.doUnchecked(() -> {
                JwtBuilder.JwtRequest request = this.getJwtRequestBuilder();
                return this.configurationContext.getAccessTokenJwtBuilder().build(request);
            });
        }
        return this.token.getId();
    }

    protected JwtBuilder.JwtRequest getJwtRequestBuilder() throws Throwable {
        Authentication authentication = this.token.getAuthentication();
        JwtBuilder.JwtRequest.JwtRequestBuilder builder = JwtBuilder.JwtRequest.builder();
        Map<String, List<Object>> attributes = this.collectAttributes();
        return builder.serviceAudience(this.determineServiceAudience()).issueDate(DateTimeUtils.dateOf((ChronoZonedDateTime)authentication.getAuthenticationDate())).jwtId(this.token.getId()).subject(authentication.getPrincipal().getId()).validUntilDate(this.determineValidUntilDate()).attributes(attributes).registeredService(Optional.of(this.registeredService)).issuer(this.determineIssuer()).service(Optional.ofNullable(this.service)).resolveSubject(this.token.isStateless()).build();
    }

    protected String determineIssuer() {
        return (String)StringUtils.defaultIfBlank((CharSequence)this.issuer, (CharSequence)this.configurationContext.getCasProperties().getServer().getPrefix());
    }

    protected Map<String, List<Object>> collectAttributes() throws Throwable {
        OAuthAccessTokenProperties accessTokenProps = this.configurationContext.getCasProperties().getAuthn().getOauth().getAccessToken();
        if (this.token instanceof OAuth20AccessToken && accessTokenProps.isIncludeClaimsInJwt()) {
            return this.collectClaimsForAccessToken();
        }
        return new HashMap<String, List<Object>>();
    }

    protected Map<String, List<Object>> collectClaimsForAccessToken() throws Throwable {
        Principal activePrincipal = this.buildPrincipalForAttributeFilter(this.token, this.registeredService);
        Principal principal = this.configurationContext.getProfileScopeToAttributesFilter().filter(this.service, activePrincipal, this.registeredService, (OAuth20AccessToken)this.token);
        HashMap<String, List<Object>> attributesToRelease = new HashMap<String, List<Object>>(principal.getAttributes());
        Map originalAttributes = activePrincipal.getAttributes();
        if (originalAttributes.containsKey("DPoPConfirmation")) {
            CollectionUtils.firstElement(originalAttributes.get("DPoPConfirmation")).ifPresent(conf -> {
                JWKThumbprintConfirmation confirmation = new JWKThumbprintConfirmation(new Base64URL(conf.toString()));
                Map.Entry claim = confirmation.toJWTClaim();
                attributesToRelease.put((String)claim.getKey(), List.of(claim.getValue()));
            });
            attributesToRelease.put("DPoP", (List)originalAttributes.get("DPoP"));
            attributesToRelease.put("DPoPConfirmation", (List)originalAttributes.get("DPoPConfirmation"));
        }
        if (originalAttributes.containsKey("x509_digest")) {
            CollectionUtils.firstElement(originalAttributes.get("x509_digest")).ifPresent(conf -> {
                X509CertificateConfirmation confirmation = new X509CertificateConfirmation(new Base64URL(conf.toString()));
                Map.Entry claim = confirmation.toJWTClaim();
                attributesToRelease.put((String)claim.getKey(), List.of(claim.getValue()));
            });
            attributesToRelease.put("x509_digest", (List)originalAttributes.get("x509_digest"));
        }
        FunctionUtils.doIfNotNull((Object)this.token.getGrantType(), type -> attributesToRelease.put("grant_type", List.of(type.getType())));
        FunctionUtils.doIfNotNull((Object)this.token.getResponseType(), type -> attributesToRelease.put("response_type", List.of(type.getType())));
        attributesToRelease.remove("password");
        return attributesToRelease;
    }

    protected Date determineValidUntilDate() {
        ZonedDateTime authenticationDate = this.token.getAuthentication().getAuthenticationDate();
        return DateTimeUtils.dateOf((ChronoZonedDateTime)authenticationDate.plusSeconds(this.token.getExpirationPolicy().getTimeToLive()));
    }

    protected Set<String> determineServiceAudience() {
        OAuthRegisteredService oauthRegisteredService = (OAuthRegisteredService)this.registeredService;
        if (StringUtils.isNotBlank((CharSequence)this.tokenAudience)) {
            return Set.of(this.tokenAudience);
        }
        if (oauthRegisteredService.getAudience().isEmpty()) {
            return Set.of(this.token.getClientId());
        }
        return oauthRegisteredService.getAudience();
    }

    protected boolean shouldEncodeAsJwt() {
        OAuthRegisteredService oauthRegisteredService = (OAuthRegisteredService)this.registeredService;
        OAuthProperties oauthProps = this.configurationContext.getCasProperties().getAuthn().getOauth();
        boolean dpopRequest = this.token.getAuthentication().containsAttribute("DPoP");
        boolean accessTokenAsJwt = this.token instanceof OAuth20AccessToken && (oauthProps.getAccessToken().isCreateAsJwt() || oauthRegisteredService.isJwtAccessToken());
        boolean refreshTokenAsJwt = this.token instanceof OAuth20RefreshToken && (oauthProps.getRefreshToken().isCreateAsJwt() || oauthRegisteredService.isJwtRefreshToken());
        return this.forceEncodeAsJwt || accessTokenAsJwt || refreshTokenAsJwt || dpopRequest;
    }

    private Principal buildPrincipalForAttributeFilter(OAuth20Token token, RegisteredService registeredService) throws Throwable {
        Authentication authentication = token.getAuthentication();
        HashMap attributes = new HashMap(authentication.getPrincipal().getAttributes());
        Map authnAttributes = this.configurationContext.getAuthenticationAttributeReleasePolicy().getAuthenticationAttributesForRelease(authentication, registeredService);
        attributes.putAll(authnAttributes);
        return this.configurationContext.getPrincipalFactory().createPrincipal(authentication.getPrincipal().getId(), attributes);
    }

    @Generated
    public OAuth20JwtAccessTokenEncodableCipher(OAuth20ConfigurationContext configurationContext, RegisteredService registeredService, OAuth20Token token, Service service, String issuer, boolean forceEncodeAsJwt) {
        this.configurationContext = configurationContext;
        this.registeredService = registeredService;
        this.token = token;
        this.service = service;
        this.issuer = issuer;
        this.forceEncodeAsJwt = forceEncodeAsJwt;
    }

    @Generated
    public OAuth20JwtAccessTokenEncodableCipher setTokenAudience(String tokenAudience) {
        this.tokenAudience = tokenAudience;
        return this;
    }

    @Generated
    public OAuth20ConfigurationContext getConfigurationContext() {
        return this.configurationContext;
    }

    @Generated
    public RegisteredService getRegisteredService() {
        return this.registeredService;
    }

    @Generated
    public OAuth20Token getToken() {
        return this.token;
    }

    @Generated
    public Service getService() {
        return this.service;
    }

    @Generated
    public String getIssuer() {
        return this.issuer;
    }

    @Generated
    public boolean isForceEncodeAsJwt() {
        return this.forceEncodeAsJwt;
    }

    @Generated
    public String getTokenAudience() {
        return this.tokenAudience;
    }
}

