/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.oauth.web;

import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.List;
import lombok.Generated;
import org.apereo.cas.support.oauth.util.OAuth20Utils;
import org.apereo.cas.ticket.Ticket;
import org.apereo.cas.ticket.registry.TicketRegistry;
import org.apereo.cas.web.cookie.CasCookieBuilder;
import org.apereo.cas.web.support.CookieUtils;
import org.pac4j.core.client.Client;
import org.pac4j.core.context.CallContext;
import org.pac4j.core.engine.DefaultSecurityLogic;
import org.pac4j.core.profile.ProfileManager;
import org.pac4j.core.profile.UserProfile;
import org.pac4j.jee.context.JEEContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OAuth20TicketGrantingTicketAwareSecurityLogic
extends DefaultSecurityLogic {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(OAuth20TicketGrantingTicketAwareSecurityLogic.class);
    private final CasCookieBuilder ticketGrantingTicketCookieGenerator;
    private final TicketRegistry ticketRegistry;

    protected List<UserProfile> loadProfiles(CallContext callContext, ProfileManager manager, List<Client> clients) {
        HttpServletRequest request = ((JEEContext)callContext.webContext()).getNativeRequest();
        Ticket ticketGrantingTicket = this.getTicketGrantingTicket(manager, request);
        Boolean statelessAuthentication = OAuth20Utils.isStatelessAuthentication(manager);
        if (ticketGrantingTicket != null || statelessAuthentication.booleanValue()) {
            return super.loadProfiles(callContext, manager, clients);
        }
        LOGGER.debug("No ticket-granting ticket => No user profiles found");
        return new ArrayList<UserProfile>();
    }

    protected Ticket getTicketGrantingTicket(ProfileManager manager, HttpServletRequest request) {
        return CookieUtils.getTicketGrantingTicketFromRequest((CasCookieBuilder)this.ticketGrantingTicketCookieGenerator, (TicketRegistry)this.ticketRegistry, (HttpServletRequest)request);
    }

    @Generated
    public OAuth20TicketGrantingTicketAwareSecurityLogic(CasCookieBuilder ticketGrantingTicketCookieGenerator, TicketRegistry ticketRegistry) {
        this.ticketGrantingTicketCookieGenerator = ticketGrantingTicketCookieGenerator;
        this.ticketRegistry = ticketRegistry;
    }
}

