/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.saml.web.idp.profile.query;

import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.attribute.PrincipalAttributeRepositoryFetcher;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.PrincipalFactoryUtils;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.services.RegisteredServiceUsernameProviderContext;
import org.apereo.cas.services.UnauthorizedServiceException;
import org.apereo.cas.support.saml.services.SamlRegisteredService;
import org.apereo.cas.support.saml.services.idp.metadata.SamlRegisteredServiceMetadataAdaptor;
import org.apereo.cas.support.saml.web.idp.profile.AbstractSamlIdPProfileHandlerController;
import org.apereo.cas.support.saml.web.idp.profile.SamlProfileHandlerConfigurationContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.AuthenticatedAssertionContext;
import org.apereo.cas.support.saml.web.idp.profile.builders.SamlProfileBuilderContext;
import org.apereo.cas.ticket.InvalidTicketException;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicket;
import org.apereo.cas.ticket.query.SamlAttributeQueryTicketFactory;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.LoggingUtils;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.saml.saml2.core.AttributeQuery;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.web.bind.annotation.PostMapping;

public class SamlIdPSaml2AttributeQueryProfileHandlerController
extends AbstractSamlIdPProfileHandlerController {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SamlIdPSaml2AttributeQueryProfileHandlerController.class);

    public SamlIdPSaml2AttributeQueryProfileHandlerController(SamlProfileHandlerConfigurationContext context) {
        super(context);
    }

    @PostMapping(path={"/idp/profile/SAML2/SOAP/AttributeQuery"})
    protected void handlePostRequest(HttpServletResponse response, HttpServletRequest request) throws Exception {
        boolean enabled = this.configurationContext.getCasProperties().getAuthn().getSamlIdp().getCore().isAttributeQueryProfileEnabled();
        if (!enabled) {
            LOGGER.warn("SAML2 attribute query profile is not enabled");
            response.setStatus(501);
            return;
        }
        MessageContext ctx = this.decodeSoapRequest(request);
        AttributeQuery query = (AttributeQuery)ctx.getMessage();
        try {
            String issuer = Objects.requireNonNull(query).getIssuer().getValue();
            SamlRegisteredService registeredService = this.verifySamlRegisteredService(issuer, request);
            Optional<SamlRegisteredServiceMetadataAdaptor> adaptor = this.getSamlMetadataFacadeFor(registeredService, (RequestAbstractType)query);
            SamlRegisteredServiceMetadataAdaptor facade = adaptor.orElseThrow(() -> UnauthorizedServiceException.denied((String)"Cannot find metadata linked to %s".formatted(issuer)));
            this.verifyAuthenticationContextSignature(ctx, request, (RequestAbstractType)query, facade, registeredService);
            String nameIdValue = this.determineNameIdForQuery(query, registeredService, facade);
            SamlAttributeQueryTicketFactory factory = (SamlAttributeQueryTicketFactory)this.getConfigurationContext().getTicketFactory().get(SamlAttributeQueryTicket.class);
            String id = factory.createTicketIdFor(nameIdValue, facade.getEntityId());
            LOGGER.debug("Created ticket id for attribute query [{}]", (Object)id);
            SamlAttributeQueryTicket ticket = (SamlAttributeQueryTicket)this.getConfigurationContext().getTicketRegistry().getTicket(id, SamlAttributeQueryTicket.class);
            if (ticket == null || ticket.isExpired()) {
                LOGGER.warn("Attribute query ticket [{}] has either expired, or it is linked to a single sign-on session that is no longer valid and has now expired", (Object)id);
                throw new InvalidTicketException(id);
            }
            Authentication authentication = ticket.getAuthentication();
            Principal principal = this.resolvePrincipalForAttributeQuery(authentication, (RegisteredService)registeredService);
            RegisteredServiceAttributeReleasePolicyContext releasePolicyContext = RegisteredServiceAttributeReleasePolicyContext.builder().registeredService((RegisteredService)registeredService).applicationContext((ApplicationContext)this.getConfigurationContext().getOpenSamlConfigBean().getApplicationContext()).service(ticket.getService()).principal(principal).build();
            Map principalAttributes = registeredService.getAttributeReleasePolicy().getConsentableAttributes(releasePolicyContext);
            LOGGER.debug("Initial consentable principal attributes are [{}]", (Object)principalAttributes);
            Map authenticationAttributes = this.getConfigurationContext().getAuthenticationAttributeReleasePolicy().getAuthenticationAttributesForRelease(authentication, null, Map.of(), (RegisteredService)registeredService);
            Map finalAttributes = CollectionUtils.merge((Map[])new Map[]{principalAttributes, authenticationAttributes});
            RegisteredServiceUsernameProviderContext usernameContext = RegisteredServiceUsernameProviderContext.builder().registeredService((RegisteredService)registeredService).service(ticket.getService()).principal(authentication.getPrincipal()).applicationContext((ApplicationContext)this.getConfigurationContext().getOpenSamlConfigBean().getApplicationContext()).build();
            String principalId = registeredService.getUsernameAttributeProvider().resolveUsername(usernameContext);
            LOGGER.debug("Principal id used for attribute query response should be [{}]", (Object)principalId);
            LOGGER.debug("Final attributes to be processed for the SAML2 response are [{}]", (Object)finalAttributes);
            AuthenticatedAssertionContext casAssertion = this.buildCasAssertion(principalId, (RegisteredService)registeredService, finalAttributes);
            request.setAttribute(AttributeQuery.class.getSimpleName(), (Object)query);
            Object buildContext = ((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)SamlProfileBuilderContext.builder().samlRequest((RequestAbstractType)query)).httpRequest(request)).httpResponse(response)).authenticatedAssertion(Optional.of(casAssertion))).registeredService(registeredService)).adaptor(facade)).binding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")).messageContext(ctx)).build();
            this.getConfigurationContext().getResponseBuilder().build((SamlProfileBuilderContext)buildContext);
        }
        catch (Throwable e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            request.setAttribute("samlError", (Object)("Unable to build SOAP response: " + StringUtils.defaultString((String)e.getMessage())));
            Object buildContext = ((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)((SamlProfileBuilderContext.SamlProfileBuilderContextBuilder)SamlProfileBuilderContext.builder().samlRequest((RequestAbstractType)query)).httpRequest(request)).httpResponse(response)).binding("urn:oasis:names:tc:SAML:2.0:bindings:SOAP")).messageContext(ctx)).build();
            this.getConfigurationContext().getSamlFaultResponseBuilder().build((SamlProfileBuilderContext)buildContext);
        }
    }

    private Principal resolvePrincipalForAttributeQuery(Authentication authentication, RegisteredService registeredService) throws Throwable {
        HashSet repositories = new HashSet(0);
        if (registeredService != null) {
            repositories.addAll(registeredService.getAttributeReleasePolicy().getPrincipalAttributesRepository().getAttributeRepositoryIds());
        }
        Principal principal = authentication.getPrincipal();
        Map attributes = PrincipalAttributeRepositoryFetcher.builder().attributeRepository(this.getConfigurationContext().getAttributeRepository()).principalId(principal.getId()).activeAttributeRepositoryIdentifiers(repositories).currentPrincipal(principal).build().retrieve();
        LOGGER.debug("Attributes retrieved from attribute repositories are [{}]", (Object)attributes);
        return PrincipalFactoryUtils.newPrincipalFactory().createPrincipal(principal.getId(), attributes);
    }

    private String determineNameIdForQuery(AttributeQuery query, SamlRegisteredService registeredService, SamlRegisteredServiceMetadataAdaptor facade) {
        return query.getSubject().getNameID() == null ? this.getConfigurationContext().getSamlObjectEncrypter().decode(query.getSubject().getEncryptedID(), registeredService, facade).getValue() : query.getSubject().getNameID().getValue();
    }
}

