/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.api;

import com.netflix.spectator.api.Counter;

final class CounterBatchUpdater
implements Counter.BatchUpdater {
    private final Counter counter;
    private final int batchSize;
    private int count;
    private double sum;

    CounterBatchUpdater(Counter counter, int batchSize) {
        this.counter = counter;
        this.batchSize = batchSize;
        this.count = 0;
        this.sum = 0.0;
    }

    @Override
    public void add(double amount) {
        if (Double.isFinite(amount) && amount > 0.0) {
            this.sum += amount;
            ++this.count;
            if (this.count >= this.batchSize) {
                this.flush();
            }
        }
    }

    @Override
    public void flush() {
        this.counter.add(this.sum);
        this.sum = 0.0;
        this.count = 0;
    }

    @Override
    public void close() throws Exception {
        this.flush();
    }
}

