/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.core.persistence.jpa;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import java.io.IOException;
import java.io.InputStream;
import org.apache.syncope.core.persistence.jpa.DomainProperties;
import org.apache.syncope.core.persistence.jpa.PersistenceProperties;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jndi.JndiObjectFactoryBean;

@EnableConfigurationProperties(value={PersistenceProperties.class})
@Configuration(proxyBeanMethods=false)
public class MasterDomain {
    @ConditionalOnMissingBean(name={"MasterDataSource"})
    @Bean(name={"MasterDataSource"})
    public JndiObjectFactoryBean masterDataSource(PersistenceProperties props) {
        HikariConfig hikariConfig = new HikariConfig();
        hikariConfig.setDriverClassName(((DomainProperties)((Object)props.getDomain().getFirst())).getJdbcDriver());
        hikariConfig.setJdbcUrl(((DomainProperties)((Object)props.getDomain().getFirst())).getJdbcURL());
        hikariConfig.setUsername(((DomainProperties)((Object)props.getDomain().getFirst())).getDbUsername());
        hikariConfig.setPassword(((DomainProperties)((Object)props.getDomain().getFirst())).getDbPassword());
        hikariConfig.setTransactionIsolation(((DomainProperties)((Object)props.getDomain().getFirst())).getTransactionIsolation().name());
        hikariConfig.setMaximumPoolSize(((DomainProperties)((Object)props.getDomain().getFirst())).getPoolMaxActive());
        hikariConfig.setMinimumIdle(((DomainProperties)((Object)props.getDomain().getFirst())).getPoolMinIdle());
        JndiObjectFactoryBean masterDataSource = new JndiObjectFactoryBean();
        masterDataSource.setJndiName("java:comp/env/jdbc/syncopeMasterDataSource");
        masterDataSource.setDefaultObject((Object)new HikariDataSource(hikariConfig));
        return masterDataSource;
    }

    @Bean(name={"MasterContentXML"})
    public InputStream masterContentXML(ResourceLoader resourceLoader, PersistenceProperties props) throws IOException {
        return resourceLoader.getResource(((DomainProperties)((Object)props.getDomain().getFirst())).getContent()).getInputStream();
    }

    @Bean(name={"MasterKeymasterConfParamsJSON"})
    public InputStream masterKeymasterConfParamsJSON(ResourceLoader resourceLoader, PersistenceProperties props) throws IOException {
        return resourceLoader.getResource(((DomainProperties)((Object)props.getDomain().getFirst())).getKeymasterConfParams()).getInputStream();
    }

    @Bean(name={"MasterDatabaseSchema"})
    public String masterDatabaseSchema(PersistenceProperties props) {
        return ((DomainProperties)((Object)props.getDomain().getFirst())).getDbSchema();
    }
}

