/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.ldap.sync;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import net.tirasa.connid.bundles.ldap.LdapConnection;
import net.tirasa.connid.bundles.ldap.commons.LdapEntry;
import net.tirasa.connid.bundles.ldap.commons.LdapUtil;
import net.tirasa.connid.bundles.ldap.commons.LdifParser;
import net.tirasa.connid.bundles.ldap.commons.PasswordDecryptor;
import net.tirasa.connid.bundles.ldap.search.LdapFilter;
import net.tirasa.connid.bundles.ldap.search.LdapSearch;
import net.tirasa.connid.bundles.ldap.search.LdapSearchStrategy;
import net.tirasa.connid.bundles.ldap.search.LdapSearches;
import net.tirasa.connid.bundles.ldap.sync.LdapSyncStrategy;
import org.identityconnectors.common.CollectionUtil;
import org.identityconnectors.common.StringUtil;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.common.security.GuardedString;
import org.identityconnectors.framework.common.exceptions.ConnectorException;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.AttributeBuilder;
import org.identityconnectors.framework.common.objects.AttributeUtil;
import org.identityconnectors.framework.common.objects.AttributesAccessor;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.ConnectorObjectBuilder;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.OperationOptionsBuilder;
import org.identityconnectors.framework.common.objects.OperationalAttributes;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.SearchResult;
import org.identityconnectors.framework.common.objects.SyncDelta;
import org.identityconnectors.framework.common.objects.SyncDeltaBuilder;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncResultsHandler;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.spi.SearchResultsHandler;

public class GenericChangeLogSyncStrategy
implements LdapSyncStrategy {
    protected static final Log LOG = Log.getLog(LdapSyncStrategy.class);
    protected static final Set<String> LDIF_MODIFY_OPS = CollectionUtil.newCaseInsensitiveSet();
    protected static final Set<String> LDAP_DN_ATTRIBUTES;
    protected final LdapConnection conn;
    protected Set<String> oclassesToSync;
    protected Set<String> attrsToSync;
    protected PasswordDecryptor passwordDecryptor;

    public GenericChangeLogSyncStrategy(LdapConnection conn) {
        this.conn = conn;
    }

    protected SyncToken getLatestSyncTokenPaged(ObjectClass oclass, OperationOptionsBuilder builder) {
        LOG.ok("Getting latest sync token with pages of size {0}", new Object[]{this.conn.getConfiguration().getChangeLogBlockSize()});
        final String[] cookies = new String[]{null};
        final int[] maxChangeNumber = new int[]{0};
        do {
            if (cookies[0] != null) {
                LOG.ok("Setting paged results cookie to {0}", new Object[]{cookies[0]});
                builder.setPagedResultsCookie(cookies[0]);
            }
            cookies[0] = null;
            SearchResultsHandler handler = new SearchResultsHandler(){

                public boolean handle(ConnectorObject object) {
                    int changeNumber;
                    Attribute changeNumberAttr = object.getAttributeByName(GenericChangeLogSyncStrategy.this.getChangeNumberAttribute());
                    if (changeNumberAttr != null && (changeNumber = GenericChangeLogSyncStrategy.convertToInt(AttributeUtil.getStringValue((Attribute)changeNumberAttr), -1)) > maxChangeNumber[0]) {
                        maxChangeNumber[0] = changeNumber;
                    }
                    return true;
                }

                public void handleResult(SearchResult result) {
                    if (result.isAllResultsReturned()) {
                        cookies[0] = result.getPagedResultsCookie();
                    }
                }
            };
            LdapSearch search = new LdapSearch(this.conn, oclass, null, (ResultsHandler)handler, builder.build(), this.conn.getConfiguration().getChangeLogContext());
            search.execute();
        } while (cookies[0] != null);
        return new SyncToken((Object)maxChangeNumber[0]);
    }

    protected SyncToken getLatestSyncTokenDefault(ObjectClass oclass, OperationOptionsBuilder builder) {
        final int[] maxChangeNumber = new int[]{0};
        LOG.ok("Getting latest sync token with a regular search", new Object[0]);
        ResultsHandler handler = new ResultsHandler(){

            public boolean handle(ConnectorObject object) {
                int changeNumber = GenericChangeLogSyncStrategy.convertToInt((String)object.getAttributeByName(GenericChangeLogSyncStrategy.this.getChangeNumberAttribute()).getValue().get(0), -1);
                if (changeNumber > maxChangeNumber[0]) {
                    maxChangeNumber[0] = changeNumber;
                }
                return true;
            }
        };
        LdapSearch search = new LdapSearch(this.conn, oclass, null, handler, builder.build(), this.conn.getConfiguration().getChangeLogContext());
        search.execute();
        return new SyncToken((Object)maxChangeNumber[0]);
    }

    @Override
    public SyncToken getLatestSyncToken(ObjectClass oclass) {
        String changeNumberAttr = this.getChangeNumberAttribute();
        OperationOptionsBuilder builder = new OperationOptionsBuilder();
        builder.setAttributesToGet(new String[]{changeNumberAttr});
        builder.setScope("onelevel");
        builder.setPageSize(Integer.valueOf(this.conn.getConfiguration().getChangeLogBlockSize()));
        builder.setOption("IGNORE_BUILT_IN_FILTERS", (Object)true);
        builder.setOption("searchFilter", (Object)"(objectClass=changelogEntry)");
        Class<? extends LdapSearchStrategy> searchStrategyClass = LdapSearchStrategy.getSearchStrategy(this.conn, builder.build());
        switch (searchStrategyClass.getSimpleName()) {
            case "PagedSearchStrategy": {
                if (this.conn.getConfiguration().getChangeLogPagingSupport()) {
                    return this.getLatestSyncTokenPaged(oclass, builder);
                }
                return this.getLatestSyncTokenDefault(oclass, builder);
            }
        }
        return this.getLatestSyncTokenDefault(oclass, builder);
    }

    @Override
    public void sync(SyncToken token, final SyncResultsHandler handler, final OperationOptions options, final ObjectClass oclass) {
        String changeNumberAttr = this.getChangeNumberAttribute();
        OperationOptionsBuilder builder = new OperationOptionsBuilder();
        builder.setScope("onelevel");
        builder.setAttributesToGet(new String[]{changeNumberAttr, "targetDN", "changeType", "changes", "newRdn", "deleteOldRdn", "newSuperior"});
        builder.setOption("IGNORE_BUILT_IN_FILTERS", (Object)true);
        final int[] currentChangeNumber = new int[]{this.getStartChangeNumber(token)};
        final boolean[] results = new boolean[1];
        ResultsHandler resultsHandler = new ResultsHandler(){

            public boolean handle(ConnectorObject object) {
                SyncDelta delta;
                results[0] = true;
                Attribute changeNumberAttr = object.getAttributeByName(GenericChangeLogSyncStrategy.this.getChangeNumberAttribute());
                int changeNumber = -1;
                if (changeNumberAttr != null && (changeNumber = GenericChangeLogSyncStrategy.convertToInt(AttributeUtil.getStringValue((Attribute)changeNumberAttr), -1)) > currentChangeNumber[0]) {
                    currentChangeNumber[0] = changeNumber;
                }
                try {
                    delta = GenericChangeLogSyncStrategy.this.createSyncDelta(object, changeNumber, options.getAttributesToGet(), oclass);
                }
                catch (InvalidNameException e) {
                    delta = null;
                }
                if (delta != null) {
                    return handler.handle(delta);
                }
                return true;
            }
        };
        do {
            results[0] = false;
            builder.setOption("searchFilter", (Object)this.getChangeLogSearchFilter(changeNumberAttr, currentChangeNumber[0]));
            LdapSearch search = new LdapSearch(this.conn, oclass, null, resultsHandler, builder.build(), this.conn.getConfiguration().getChangeLogContext());
            search.execute();
            if (!results[0]) continue;
            currentChangeNumber[0] = currentChangeNumber[0] + 1;
        } while (results[0]);
    }

    protected SyncDelta createSyncDelta(ConnectorObject inputObject, int changeNumber, String[] attrsToGetOption, ObjectClass oclass) throws InvalidNameException {
        String uidAttr;
        List<Object> passwordValues;
        Set attrsToGet;
        LOG.ok("Attempting to create sync delta for log entry {0}", new Object[]{changeNumber});
        AttributesAccessor inputAttrs = new AttributesAccessor(inputObject.getAttributes());
        String targetDN = inputAttrs.findString("targetDN");
        if (targetDN == null) {
            LOG.error("Skipping log entry because it does not have a targetDN attribute", new Object[0]);
            return null;
        }
        LdapName targetName = LdapUtil.quietCreateLdapName(targetDN);
        if (this.filterOutByBaseContexts(targetName)) {
            LOG.ok("Skipping log entry because it does not match any of the base contexts to synchronize", new Object[0]);
            return null;
        }
        String changeType = inputAttrs.findString("changeType");
        SyncDeltaType deltaType = this.getSyncDeltaType(changeType);
        SyncDeltaBuilder syncDeltaBuilder = new SyncDeltaBuilder();
        syncDeltaBuilder.setToken(new SyncToken((Object)changeNumber));
        syncDeltaBuilder.setDeltaType(deltaType);
        if (deltaType.equals((Object)SyncDeltaType.DELETE)) {
            return this.createDeletionSyncDelta(syncDeltaBuilder, targetDN, oclass, inputAttrs);
        }
        String changes = inputAttrs.findString("changes");
        Map<String, List<Object>> attrChanges = this.getAttributeChanges(changeType, changes);
        if (this.filterOutByModifiersNames(attrChanges)) {
            LOG.ok("Skipping entry because modifiersName is in the list of modifiersName's to filter out", new Object[0]);
            return null;
        }
        if (this.filterOutByAttributes(attrChanges)) {
            LOG.ok("Skipping entry because no changed attributes in the list of attributes to synchronize", new Object[0]);
            return null;
        }
        String newTargetDN = targetDN;
        if ("modrdn".equalsIgnoreCase(changeType)) {
            String newRdn = inputAttrs.findString("newRdn");
            if (StringUtil.isBlank((String)newRdn)) {
                LOG.error("Skipping log entry because it does not have a newRdn attribute", new Object[0]);
                return null;
            }
            String newSuperior = inputAttrs.findString("newSuperior");
            newTargetDN = this.getNewTargetDN(targetName, newSuperior, newRdn);
        }
        if (attrsToGetOption != null) {
            attrsToGet = CollectionUtil.newSet((Object[])attrsToGetOption);
            attrsToGet.remove(OperationalAttributes.PASSWORD_NAME);
        } else {
            attrsToGet = CollectionUtil.newSet(LdapSearch.getAttributesReturnedByDefault(this.conn, oclass));
        }
        boolean removeObjectClass = attrsToGet.add("objectClass");
        LdapFilter filter = LdapFilter.forEntryDN(newTargetDN).withNativeFilter(this.getModifiedEntrySearchFilter(oclass));
        ConnectorObject object = LdapSearches.findObject(this.conn, oclass, filter, attrsToGet.toArray(new String[0]));
        if (object == null) {
            LOG.ok("Skipping entry because the modified entry is missing, not of the right object class, or not matching the search filter", new Object[0]);
            return null;
        }
        Attribute oclassAttr = object.getAttributeByName("objectClass");
        List<String> objectClasses = LdapUtil.checkedListByFilter(CollectionUtil.nullAsEmpty((List)oclassAttr.getValue()), String.class);
        if (this.filterOutByObjectClasses(objectClasses)) {
            LOG.ok("Skipping entry because no object class in the list of object classes to synchronize", new Object[0]);
            return null;
        }
        Attribute passwordAttr = null;
        if (this.conn.getConfiguration().isSynchronizePasswords() && !(passwordValues = attrChanges.get(this.conn.getConfiguration().getPasswordAttributeToSynchronize())).isEmpty()) {
            byte[] encryptedPwd = (byte[])passwordValues.get(0);
            String decryptedPwd = this.getPasswordDecryptor().decryptPassword(encryptedPwd);
            passwordAttr = AttributeBuilder.buildPassword((GuardedString)new GuardedString(decryptedPwd.toCharArray()));
        }
        if (removeObjectClass || passwordAttr != null) {
            ConnectorObjectBuilder objectBuilder = new ConnectorObjectBuilder();
            objectBuilder.setObjectClass(object.getObjectClass());
            objectBuilder.setUid(object.getUid());
            objectBuilder.setName(object.getName());
            if (removeObjectClass) {
                for (Attribute attr : object.getAttributes()) {
                    if (attr == oclassAttr) continue;
                    objectBuilder.addAttribute(new Attribute[]{attr});
                }
            } else {
                objectBuilder.addAttributes((Collection)object.getAttributes());
            }
            if (passwordAttr != null) {
                objectBuilder.addAttribute(new Attribute[]{passwordAttr});
            }
            object = objectBuilder.build();
        }
        LOG.ok("Creating sync delta for created or updated entry", new Object[0]);
        if ("modrdn".equalsIgnoreCase(changeType) && LdapEntry.isDNAttribute(uidAttr = this.conn.getSchema().getLdapUidAttribute(oclass))) {
            syncDeltaBuilder.setPreviousUid(this.conn.getSchema().createUid(oclass, targetDN));
        }
        syncDeltaBuilder.setUid(object.getUid());
        syncDeltaBuilder.setObject(object);
        return syncDeltaBuilder.build();
    }

    protected SyncDelta createDeletionSyncDelta(SyncDeltaBuilder syncDeltaBuilder, String targetDN, ObjectClass oclass, AttributesAccessor inputAttrs) throws InvalidNameException {
        LOG.ok("Creating sync delta for deleted entry {0}", new Object[]{targetDN});
        Uid deletedUid = new Uid(targetDN);
        ConnectorObjectBuilder objectBuilder = new ConnectorObjectBuilder();
        objectBuilder.setObjectClass(oclass);
        objectBuilder.setUid(deletedUid);
        objectBuilder.setName("fake-dn");
        objectBuilder.addAttributes(Collections.emptySet());
        syncDeltaBuilder.setUid(deletedUid);
        syncDeltaBuilder.setObject(objectBuilder.build());
        return syncDeltaBuilder.build();
    }

    protected String getNewTargetDN(LdapName targetName, String newSuperior, String newRdn) {
        try {
            LdapName newTargetName;
            if (newSuperior == null) {
                newTargetName = new LdapName(targetName.getRdns());
                if (newTargetName.size() > 0) {
                    newTargetName.remove(targetName.size() - 1);
                }
            } else {
                newTargetName = LdapUtil.quietCreateLdapName(newSuperior);
            }
            newTargetName.add(newRdn);
            return newTargetName.toString();
        }
        catch (InvalidNameException e) {
            throw new ConnectorException((Throwable)e);
        }
    }

    protected boolean filterOutByBaseContexts(LdapName targetName) {
        List<LdapName> baseContexts = this.conn.getConfiguration().getBaseContextsToSynchronizeAsLdapNames();
        if (baseContexts.isEmpty()) {
            baseContexts = this.conn.getConfiguration().getBaseContextsAsLdapNames();
        }
        return !LdapUtil.isUnderContexts(targetName, baseContexts);
    }

    protected boolean filterOutByModifiersNames(Map<String, List<Object>> changes) {
        Set<LdapName> filter = this.conn.getConfiguration().getModifiersNamesToFilterOutAsLdapNames();
        if (filter.isEmpty()) {
            LOG.ok("Filtering by modifiersName disabled", new Object[0]);
            return false;
        }
        List<Object> modifiersNameValues = changes.get("modifiersName");
        if (CollectionUtil.isEmpty(modifiersNameValues)) {
            LOG.ok("Not filtering by modifiersName because not set for this entry", new Object[0]);
            return false;
        }
        LdapName modifiersName = LdapUtil.quietCreateLdapName(modifiersNameValues.get(0).toString());
        return filter.contains(modifiersName);
    }

    protected boolean filterOutByAttributes(Map<String, List<Object>> attrChanges) {
        Set<String> filter = this.getAttributesToSynchronize();
        if (filter.isEmpty()) {
            LOG.ok("Filtering by attributes disabled", new Object[0]);
            return false;
        }
        Set<String> changedAttrs = attrChanges.keySet();
        return !this.containsAny(filter, changedAttrs);
    }

    protected boolean filterOutByObjectClasses(List<String> objectClasses) {
        Set<String> filter = this.getObjectClassesToSynchronize();
        if (filter.isEmpty()) {
            LOG.ok("Filtering by object class disabled", new Object[0]);
            return false;
        }
        return !this.containsAny(filter, objectClasses);
    }

    protected SyncDeltaType getSyncDeltaType(String changeType) {
        if ("delete".equalsIgnoreCase(changeType)) {
            return SyncDeltaType.DELETE;
        }
        return SyncDeltaType.CREATE_OR_UPDATE;
    }

    protected String getModifiedEntrySearchFilter(ObjectClass oclass) {
        if (oclass.equals((Object)ObjectClass.ACCOUNT)) {
            return this.conn.getConfiguration().getAccountSynchronizationFilter();
        }
        return null;
    }

    protected int getStartChangeNumber(SyncToken lastToken) {
        return lastToken != null ? (Integer)lastToken.getValue() + 1 : 0;
    }

    protected Map<String, List<Object>> getAttributeChanges(String changeType, String ldif) {
        SortedMap result;
        block5: {
            block4: {
                result = CollectionUtil.newCaseInsensitiveMap();
                if (!"modify".equalsIgnoreCase(changeType)) break block4;
                LdifParser parser = new LdifParser(ldif);
                Iterator<LdifParser.Line> lines = parser.iterator();
                while (lines.hasNext()) {
                    LdifParser.Line line = lines.next();
                    if (line instanceof LdifParser.Separator || line instanceof LdifParser.ChangeSeparator) continue;
                    LdifParser.NameValue nameValue = (LdifParser.NameValue)line;
                    String operation = nameValue.getName();
                    String attrName = nameValue.getValue();
                    if (!LDIF_MODIFY_OPS.contains(operation)) continue;
                    ArrayList<Object> values = new ArrayList<Object>();
                    while (lines.hasNext() && !((line = lines.next()) instanceof LdifParser.Separator)) {
                        nameValue = (LdifParser.NameValue)line;
                        Object value = this.decodeAttributeValue(nameValue);
                        if (value == null) continue;
                        values.add(value);
                    }
                    if (values.isEmpty()) continue;
                    result.put(attrName, values);
                }
                break block5;
            }
            if (!"add".equalsIgnoreCase(changeType)) break block5;
            LdifParser parser = new LdifParser(ldif);
            for (LdifParser.Line line : parser) {
                LdifParser.NameValue nameValue;
                Object value;
                if (line instanceof LdifParser.Separator || line instanceof LdifParser.ChangeSeparator || (value = this.decodeAttributeValue(nameValue = (LdifParser.NameValue)line)) == null) continue;
                ArrayList<Object> values = (ArrayList<Object>)result.get(nameValue.getName());
                if (values == null) {
                    values = new ArrayList<Object>();
                    result.put(nameValue.getName(), values);
                }
                values.add(value);
            }
        }
        return result;
    }

    protected Object decodeAttributeValue(LdifParser.NameValue nameValue) {
        String value = nameValue.getValue();
        if (value.startsWith(":")) {
            String base64 = value.substring(1).trim();
            try {
                return Base64.getDecoder().decode(base64);
            }
            catch (Exception e) {
                LOG.error("Could not decode attribute {0} with Base64 value {1}", new Object[]{nameValue.getName(), nameValue.getValue()});
                return null;
            }
        }
        return value;
    }

    protected String getChangeLogSearchFilter(String changeNumberAttr, int startChangeNumber) {
        int blockSize = this.conn.getConfiguration().getChangeLogBlockSize();
        boolean filterWithOrInsteadOfAnd = this.conn.getConfiguration().isFilterWithOrInsteadOfAnd();
        boolean filterByLogEntryOClass = !this.conn.getConfiguration().isRemoveLogEntryObjectClassFromFilter();
        StringBuilder result = new StringBuilder();
        if (filterWithOrInsteadOfAnd) {
            if (filterByLogEntryOClass) {
                result.append("(&(objectClass=changeLogEntry)");
            }
            result.append("(|(");
            result.append(changeNumberAttr);
            result.append('=');
            result.append(startChangeNumber);
            result.append(')');
            int endChangeNumber = startChangeNumber + blockSize;
            for (int i = startChangeNumber + 1; i <= endChangeNumber; ++i) {
                result.append("(");
                result.append(changeNumberAttr);
                result.append('=');
                result.append(i);
                result.append(')');
            }
            result.append(')');
            if (filterByLogEntryOClass) {
                result.append(')');
            }
        } else {
            result.append("(&");
            if (filterByLogEntryOClass) {
                result.append("(objectClass=changeLogEntry)");
            }
            result.append("(");
            result.append(changeNumberAttr);
            result.append(">=");
            result.append(startChangeNumber);
            result.append(')');
            int endChangeNumber = startChangeNumber + blockSize;
            result.append("(");
            result.append(changeNumberAttr);
            result.append("<=");
            result.append(endChangeNumber);
            result.append(')');
            result.append(')');
        }
        return result.toString();
    }

    protected String getChangeNumberAttribute() {
        String result = this.conn.getConfiguration().getChangeNumberAttribute();
        if (StringUtil.isBlank((String)result)) {
            result = "changeNumber";
        }
        return result;
    }

    protected Set<String> getAttributesToSynchronize() {
        if (this.attrsToSync == null) {
            SortedSet result = CollectionUtil.newCaseInsensitiveSet();
            result.addAll(Arrays.asList(LdapUtil.nullAsEmpty(this.conn.getConfiguration().getAttributesToSynchronize())));
            if (this.conn.getConfiguration().isSynchronizePasswords()) {
                result.add(this.conn.getConfiguration().getPasswordAttributeToSynchronize());
            }
            this.attrsToSync = result;
        }
        return this.attrsToSync;
    }

    protected Set<String> getObjectClassesToSynchronize() {
        if (this.oclassesToSync == null) {
            SortedSet result = CollectionUtil.newCaseInsensitiveSet();
            result.addAll(Arrays.asList(LdapUtil.nullAsEmpty(this.conn.getConfiguration().getObjectClassesToSynchronize())));
            this.oclassesToSync = result;
        }
        return this.oclassesToSync;
    }

    protected PasswordDecryptor getPasswordDecryptor() {
        if (this.passwordDecryptor == null) {
            this.conn.getConfiguration().getPasswordDecryptionKey().access(decryptionKey -> this.conn.getConfiguration().getPasswordDecryptionInitializationVector().access(decryptionIV -> {
                this.passwordDecryptor = new PasswordDecryptor(decryptionKey, decryptionIV);
            }));
        }
        assert (this.passwordDecryptor != null);
        return this.passwordDecryptor;
    }

    protected boolean containsAny(Set<String> haystack, Collection<String> needles) {
        for (String needle : needles) {
            if (!haystack.contains(needle)) continue;
            return true;
        }
        return false;
    }

    protected Uid createUid(String uidAttr, String targetDN) throws InvalidNameException {
        Rdn matchingRnd = null;
        for (Rdn rdn : new LdapName(targetDN).getRdns()) {
            if (!uidAttr.equalsIgnoreCase(rdn.getType())) continue;
            matchingRnd = rdn;
        }
        return matchingRnd == null ? null : new Uid(matchingRnd.getValue().toString());
    }

    protected static int convertToInt(String number, int def) {
        int result = def;
        if (number != null && number.length() > 0) {
            int decimal = number.indexOf(46);
            if (decimal > 0) {
                number = number.substring(0, decimal);
            }
            try {
                result = Integer.parseInt(number);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    static {
        LDIF_MODIFY_OPS.add("add");
        LDIF_MODIFY_OPS.add("delete");
        LDIF_MODIFY_OPS.add("replace");
        LDAP_DN_ATTRIBUTES = CollectionUtil.newCaseInsensitiveSet();
        LDAP_DN_ATTRIBUTES.add("uid");
        LDAP_DN_ATTRIBUTES.add("cn");
    }
}

