/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.client.console.policies;

import com.fasterxml.jackson.databind.json.JsonMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.stream.Collectors;
import org.apache.syncope.client.console.panels.BeanPanel;
import org.apache.syncope.client.console.policies.PolicyRuleWrapper;
import org.apache.syncope.client.console.rest.ImplementationRestClient;
import org.apache.syncope.client.console.rest.PolicyRestClient;
import org.apache.syncope.client.console.wizards.BaseAjaxWizardBuilder;
import org.apache.syncope.client.ui.commons.markup.html.form.AjaxDropDownChoicePanel;
import org.apache.syncope.common.lib.policy.ComposablePolicy;
import org.apache.syncope.common.lib.policy.RuleConf;
import org.apache.syncope.common.lib.to.ImplementationTO;
import org.apache.syncope.common.lib.types.ImplementationEngine;
import org.apache.syncope.common.lib.types.PolicyType;
import org.apache.wicket.Component;
import org.apache.wicket.PageReference;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.ajax.AjaxEventBehavior;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.wizard.IWizardStep;
import org.apache.wicket.extensions.wizard.WizardModel;
import org.apache.wicket.extensions.wizard.WizardStep;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;
import org.apache.wicket.model.PropertyModel;

public class PolicyRuleWizardBuilder
extends BaseAjaxWizardBuilder<PolicyRuleWrapper> {
    private static final long serialVersionUID = 5945391813567245081L;
    protected static final JsonMapper MAPPER = (JsonMapper)((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
    protected final String policy;
    protected final PolicyType type;
    protected final String implementationType;
    protected final PolicyRestClient policyRestClient;
    protected final ImplementationRestClient implementationRestClient;

    public PolicyRuleWizardBuilder(String policy, PolicyType type, PolicyRuleWrapper policyWrapper, PolicyRestClient policyRestClient, ImplementationRestClient implementationRestClient, PageReference pageRef) {
        super(policyWrapper, pageRef);
        this.policy = policy;
        this.type = type;
        this.implementationType = type == PolicyType.ACCOUNT ? "ACCOUNT_RULE" : "PASSWORD_RULE";
        this.policyRestClient = policyRestClient;
        this.implementationRestClient = implementationRestClient;
    }

    protected Serializable onApplyInternal(PolicyRuleWrapper modelObject) {
        ComposablePolicy composablePolicy;
        Object policyTO = this.policyRestClient.read(this.type, this.policy);
        if (!(policyTO instanceof ComposablePolicy)) {
            throw new IllegalStateException("Non composable policy");
        }
        ComposablePolicy composable = composablePolicy = (ComposablePolicy)policyTO;
        if (modelObject.getImplementationEngine() == ImplementationEngine.JAVA) {
            ImplementationTO rule = this.implementationRestClient.read(this.implementationType, modelObject.getImplementationKey());
            try {
                rule.setBody(MAPPER.writeValueAsString((Object)modelObject.getConf()));
                this.implementationRestClient.update(rule);
            }
            catch (Exception e) {
                throw new WicketRuntimeException((Throwable)e);
            }
        }
        if (modelObject.isNew()) {
            composable.getRules().add(modelObject.getImplementationKey());
        }
        this.policyRestClient.update(this.type, policyTO);
        return modelObject;
    }

    protected WizardModel buildModelSteps(PolicyRuleWrapper modelObject, WizardModel wizardModel) {
        wizardModel.add((IWizardStep)new Profile(modelObject));
        wizardModel.add((IWizardStep)new Configuration(modelObject));
        return wizardModel;
    }

    public class Profile
    extends WizardStep {
        private static final long serialVersionUID = -3043839139187792810L;
        private final PolicyRuleWrapper rule;

        public Profile(final PolicyRuleWrapper rule) {
            this.rule = rule;
            final AjaxDropDownChoicePanel conf = new AjaxDropDownChoicePanel("rule", "rule", (IModel)new PropertyModel((Object)rule, "implementationKey"));
            conf.setChoices(switch (PolicyRuleWizardBuilder.this.type) {
                case PolicyType.ACCOUNT -> PolicyRuleWizardBuilder.this.implementationRestClient.list("ACCOUNT_RULE").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
                case PolicyType.PASSWORD -> PolicyRuleWizardBuilder.this.implementationRestClient.list("PASSWORD_RULE").stream().map(ImplementationTO::getKey).sorted().collect(Collectors.toList());
                default -> new ArrayList();
            });
            conf.addRequiredLabel();
            conf.setNullValid(false);
            conf.setEnabled(rule.isNew());
            conf.add(new Behavior[]{new AjaxEventBehavior("change"){
                private static final long serialVersionUID = -7133385027739964990L;

                protected void onEvent(AjaxRequestTarget target) {
                    ImplementationTO impl = PolicyRuleWizardBuilder.this.implementationRestClient.read(PolicyRuleWizardBuilder.this.implementationType, (String)((Object)conf.getModelObject()));
                    rule.setImplementationEngine(impl.getEngine());
                    if (impl.getEngine() == ImplementationEngine.JAVA) {
                        try {
                            rule.setConf((RuleConf)MAPPER.readValue(impl.getBody(), RuleConf.class));
                        }
                        catch (Exception e) {
                            LOG.error("During deserialization", (Throwable)e);
                        }
                    }
                }
            }});
            this.add(new Component[]{conf});
        }

        public void applyState() {
            if (this.rule.getImplementationEngine() == ImplementationEngine.GROOVY) {
                this.getWizardModel().finish();
            }
        }
    }

    public class Configuration
    extends WizardStep {
        private static final long serialVersionUID = -785981096328637758L;

        public Configuration(final PolicyRuleWrapper rule) {
            LoadableDetachableModel<Serializable> bean = new LoadableDetachableModel<Serializable>(){
                private static final long serialVersionUID = 2092144708018739371L;

                protected Serializable load() {
                    return rule.getConf();
                }
            };
            this.add(new Component[]{new BeanPanel("bean", bean, PolicyRuleWizardBuilder.this.pageRef, new String[0]).setRenderBodyOnly(true)});
        }
    }
}

