/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.config;

import java.lang.reflect.Method;
import java.util.LinkedHashMap;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.BeanFactory;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.core.convert.ConversionService;
import org.springframework.expression.IndexAccessor;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypeConverter;
import org.springframework.expression.spel.support.StandardTypeConverter;
import org.springframework.integration.config.SpelFunctionFactoryBean;
import org.springframework.integration.expression.SpelPropertyAccessorRegistrar;
import org.springframework.integration.support.utils.IntegrationUtils;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractEvaluationContextFactoryBean
implements ApplicationContextAware,
InitializingBean {
    private Map<String, PropertyAccessor> propertyAccessors = new LinkedHashMap<String, PropertyAccessor>();
    private Map<String, IndexAccessor> indexAccessors = new LinkedHashMap<String, IndexAccessor>();
    private Map<String, Method> functions = new LinkedHashMap<String, Method>();
    private TypeConverter typeConverter = new StandardTypeConverter();
    private ApplicationContext applicationContext;
    @Nullable
    private SpelPropertyAccessorRegistrar propertyAccessorRegistrar;
    private boolean initialized;

    protected TypeConverter getTypeConverter() {
        return this.typeConverter;
    }

    protected ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        this.applicationContext = applicationContext;
    }

    public void setPropertyAccessors(Map<String, PropertyAccessor> propertyAccessors) {
        Assert.isTrue((!this.initialized ? 1 : 0) != 0, (String)"'propertyAccessors' can't be changed after initialization.");
        Assert.notNull(propertyAccessors, (String)"'propertyAccessors' must not be null.");
        Assert.noNullElements((Object[])propertyAccessors.values().toArray(), (String)"'propertyAccessors' cannot have null values.");
        this.propertyAccessors = new LinkedHashMap<String, PropertyAccessor>(propertyAccessors);
    }

    public Map<String, PropertyAccessor> getPropertyAccessors() {
        return this.propertyAccessors;
    }

    public void setIndexAccessors(Map<String, IndexAccessor> indexAccessors) {
        Assert.isTrue((!this.initialized ? 1 : 0) != 0, (String)"'indexAccessors' can't be changed after initialization.");
        Assert.notNull(indexAccessors, (String)"'indexAccessors' must not be null.");
        Assert.noNullElements((Object[])indexAccessors.values().toArray(), (String)"'indexAccessors' cannot have null values.");
        this.indexAccessors = new LinkedHashMap<String, IndexAccessor>(indexAccessors);
    }

    public Map<String, IndexAccessor> getIndexAccessors() {
        return this.indexAccessors;
    }

    public void setFunctions(Map<String, Method> functionsArg) {
        Assert.isTrue((!this.initialized ? 1 : 0) != 0, (String)"'functions' can't be changed after initialization.");
        Assert.notNull(functionsArg, (String)"'functions' must not be null.");
        Assert.noNullElements((Object[])functionsArg.values().toArray(), (String)"'functions' cannot have null values.");
        this.functions = new LinkedHashMap<String, Method>(functionsArg);
    }

    public Map<String, Method> getFunctions() {
        return this.functions;
    }

    protected void initialize(String beanName) {
        if (this.applicationContext != null) {
            this.conversionService();
            this.functions();
            try {
                this.propertyAccessorRegistrar = (SpelPropertyAccessorRegistrar)this.applicationContext.getBean(SpelPropertyAccessorRegistrar.class);
            }
            catch (NoSuchBeanDefinitionException noSuchBeanDefinitionException) {
                // empty catch block
            }
            this.propertyAccessors();
            this.indexAccessors();
            this.processParentIfPresent(beanName);
        }
        this.initialized = true;
    }

    private void conversionService() {
        ConversionService conversionService = IntegrationUtils.getConversionService((BeanFactory)this.getApplicationContext());
        if (conversionService != null) {
            this.typeConverter = new StandardTypeConverter(conversionService);
        }
    }

    private void functions() {
        Map spelFunctions = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)this.applicationContext, SpelFunctionFactoryBean.class);
        for (SpelFunctionFactoryBean spelFunctionFactoryBean : spelFunctions.values()) {
            String functionName = spelFunctionFactoryBean.getFunctionName();
            if (this.functions.containsKey(functionName)) continue;
            this.functions.put(functionName, spelFunctionFactoryBean.getObject());
        }
    }

    private void propertyAccessors() {
        if (this.propertyAccessorRegistrar != null) {
            this.propertyAccessors(this.propertyAccessorRegistrar.getPropertyAccessors());
        }
    }

    private void propertyAccessors(Map<String, PropertyAccessor> propertyAccessors) {
        for (Map.Entry<String, PropertyAccessor> entry : propertyAccessors.entrySet()) {
            String key = entry.getKey();
            if (this.propertyAccessors.containsKey(key)) continue;
            this.propertyAccessors.put(key, entry.getValue());
        }
    }

    private void indexAccessors() {
        if (this.propertyAccessorRegistrar != null) {
            this.indexAccessors(this.propertyAccessorRegistrar.getIndexAccessors());
        }
    }

    private void indexAccessors(Map<String, IndexAccessor> indexAccessors) {
        for (Map.Entry<String, IndexAccessor> entry : indexAccessors.entrySet()) {
            String key = entry.getKey();
            if (this.indexAccessors.containsKey(key)) continue;
            this.indexAccessors.put(key, entry.getValue());
        }
    }

    private void processParentIfPresent(String beanName) {
        ApplicationContext parent = this.applicationContext.getParent();
        if (parent != null && parent.containsBean(beanName)) {
            AbstractEvaluationContextFactoryBean parentFactoryBean = (AbstractEvaluationContextFactoryBean)parent.getBean("&" + beanName, this.getClass());
            this.propertyAccessors(parentFactoryBean.getPropertyAccessors());
            this.indexAccessors(parentFactoryBean.getIndexAccessors());
            for (Map.Entry<String, Method> entry : parentFactoryBean.getFunctions().entrySet()) {
                String key = entry.getKey();
                if (this.functions.containsKey(key)) continue;
                this.functions.put(key, entry.getValue());
            }
        }
    }
}

