/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.integration.channel;

import java.util.concurrent.Executor;
import java.util.function.Predicate;
import org.springframework.integration.channel.AbstractExecutorChannel;
import org.springframework.integration.channel.ChannelUtils;
import org.springframework.integration.dispatcher.LoadBalancingStrategy;
import org.springframework.integration.dispatcher.RoundRobinLoadBalancingStrategy;
import org.springframework.integration.dispatcher.UnicastingDispatcher;
import org.springframework.integration.util.ErrorHandlingTaskExecutor;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;
import org.springframework.util.ErrorHandler;

public class ExecutorChannel
extends AbstractExecutorChannel {
    private final LoadBalancingStrategy loadBalancingStrategy;
    private Predicate<Exception> failoverStrategy = exception -> true;

    public ExecutorChannel(Executor executor) {
        this(executor, new RoundRobinLoadBalancingStrategy());
    }

    public ExecutorChannel(Executor executor, @Nullable LoadBalancingStrategy loadBalancingStrategy) {
        super(executor);
        Assert.notNull((Object)executor, (String)"executor must not be null");
        UnicastingDispatcher unicastingDispatcher = new UnicastingDispatcher(executor);
        this.loadBalancingStrategy = loadBalancingStrategy;
        if (this.loadBalancingStrategy != null) {
            unicastingDispatcher.setLoadBalancingStrategy(this.loadBalancingStrategy);
        }
        this.dispatcher = unicastingDispatcher;
    }

    public void setFailover(boolean failover) {
        this.setFailoverStrategy(exception -> failover);
    }

    public void setFailoverStrategy(Predicate<Exception> failoverStrategy) {
        this.failoverStrategy = failoverStrategy;
        this.getDispatcher().setFailoverStrategy(failoverStrategy);
    }

    @Override
    protected UnicastingDispatcher getDispatcher() {
        return (UnicastingDispatcher)this.dispatcher;
    }

    @Override
    public final void onInit() {
        Assert.state((this.getDispatcher().getHandlerCount() == 0 ? 1 : 0) != 0, (String)"You cannot subscribe() until the channel bean is fully initialized by the framework. Do not subscribe in a @Bean definition");
        super.onInit();
        if (!(this.executor instanceof ErrorHandlingTaskExecutor)) {
            ErrorHandler errorHandler = ChannelUtils.getErrorHandler(this.getBeanFactory());
            this.executor = new ErrorHandlingTaskExecutor(this.executor, errorHandler);
        }
        UnicastingDispatcher unicastingDispatcher = new UnicastingDispatcher(this.executor);
        unicastingDispatcher.setFailoverStrategy(this.failoverStrategy);
        if (this.maxSubscribers == null) {
            this.maxSubscribers = this.getIntegrationProperties().getChannelsMaxUnicastSubscribers();
        }
        unicastingDispatcher.setMaxSubscribers(this.maxSubscribers);
        if (this.loadBalancingStrategy != null) {
            unicastingDispatcher.setLoadBalancingStrategy(this.loadBalancingStrategy);
        }
        unicastingDispatcher.setMessageHandlingTaskDecorator(task -> {
            if (this.executorInterceptorsSize > 0) {
                return new AbstractExecutorChannel.MessageHandlingTask(task);
            }
            return task;
        });
        this.dispatcher = unicastingDispatcher;
    }
}

