/*
 * Decompiled with CFR 0.152.
 */
package net.tirasa.connid.bundles.cmd;

import java.net.ConnectException;
import java.util.Map;
import java.util.Set;
import net.tirasa.connid.bundles.cmd.CmdConfiguration;
import net.tirasa.connid.bundles.cmd.CmdFilterTranslator;
import net.tirasa.connid.bundles.cmd.methods.CmdCreate;
import net.tirasa.connid.bundles.cmd.methods.CmdDelete;
import net.tirasa.connid.bundles.cmd.methods.CmdExecuteQuery;
import net.tirasa.connid.bundles.cmd.methods.CmdTest;
import net.tirasa.connid.bundles.cmd.methods.CmdUpdate;
import net.tirasa.connid.bundles.cmd.search.Operand;
import org.identityconnectors.common.logging.Log;
import org.identityconnectors.framework.common.objects.Attribute;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.OperationOptions;
import org.identityconnectors.framework.common.objects.ResultsHandler;
import org.identityconnectors.framework.common.objects.Uid;
import org.identityconnectors.framework.common.objects.filter.FilterTranslator;
import org.identityconnectors.framework.spi.Configuration;
import org.identityconnectors.framework.spi.Connector;
import org.identityconnectors.framework.spi.ConnectorClass;
import org.identityconnectors.framework.spi.operations.CreateOp;
import org.identityconnectors.framework.spi.operations.DeleteOp;
import org.identityconnectors.framework.spi.operations.SearchOp;
import org.identityconnectors.framework.spi.operations.TestOp;
import org.identityconnectors.framework.spi.operations.UpdateOp;

@ConnectorClass(configurationClass=CmdConfiguration.class, displayNameKey="cmd.connector.display")
public class CmdConnector
implements Connector,
CreateOp,
UpdateOp,
DeleteOp,
TestOp,
SearchOp<Operand> {
    private static final Log LOG = Log.getLog(CmdConnector.class);
    private CmdConfiguration cmdConfiguration;

    public Configuration getConfiguration() {
        return this.cmdConfiguration;
    }

    public void init(Configuration configuration) {
        this.cmdConfiguration = (CmdConfiguration)configuration;
    }

    public void dispose() {
    }

    public Uid create(ObjectClass oc, Set<Attribute> attributes, OperationOptions oo) {
        if (LOG.isOk()) {
            LOG.ok("Create parameters:", new Object[0]);
            LOG.ok("ObjectClass {0}", new Object[]{oc.getObjectClassValue()});
            for (Attribute attribute : attributes) {
                LOG.ok("Attribute {0}: {1}", new Object[]{attribute.getName(), attribute.getValue()});
            }
            if (oo != null) {
                for (Map.Entry entry : oo.getOptions().entrySet()) {
                    String key = (String)entry.getKey();
                    Object value = entry.getValue();
                    LOG.ok("OperationOptions {0}: {1}", new Object[]{key, value});
                }
            }
        }
        return new CmdCreate(oc, this.cmdConfiguration, attributes).execCreateCmd();
    }

    public Uid update(ObjectClass oc, Uid uid, Set<Attribute> attributes, OperationOptions oo) {
        if (LOG.isOk()) {
            LOG.ok("Update parameters:", new Object[0]);
            LOG.ok("ObjectClass {0}", new Object[]{oc.getObjectClassValue()});
            LOG.ok("Uid: {0}", new Object[]{uid.getUidValue()});
            for (Attribute attribute : attributes) {
                LOG.ok("Attribute {0}: {1}", new Object[]{attribute.getName(), attribute.getValue()});
            }
            if (oo != null) {
                for (Map.Entry entry : oo.getOptions().entrySet()) {
                    LOG.ok("   > OperationOptions {0}", new Object[]{(String)entry.getKey() + ": " + entry.getValue()});
                }
            }
        }
        return new CmdUpdate(oc, this.cmdConfiguration, uid, attributes).execUpdateCmd();
    }

    public void delete(ObjectClass oc, Uid uid, OperationOptions oo) {
        if (LOG.isOk()) {
            LOG.ok("Delete parameters:", new Object[0]);
            LOG.ok("ObjectClass {0}", new Object[]{oc.getObjectClassValue()});
            LOG.ok("Uid: {0}", new Object[]{uid.getUidValue()});
            if (oo != null) {
                for (Map.Entry entrySet : oo.getOptions().entrySet()) {
                    LOG.ok("OperationOptions {0}: {1}", new Object[]{entrySet.getKey(), entrySet.getValue()});
                }
            }
        }
        new CmdDelete(oc, this.cmdConfiguration, uid).execDeleteCmd();
    }

    public void test() {
        LOG.ok("Remote connection test", new Object[0]);
        new CmdTest(this.cmdConfiguration).test();
    }

    public void executeQuery(ObjectClass oc, Operand operand, ResultsHandler rh, OperationOptions oo) {
        if (LOG.isOk()) {
            LOG.ok("Search parameters:", new Object[0]);
            LOG.ok("ObjectClass {0}", new Object[]{oc.getObjectClassValue()});
            LOG.ok("Operand {0}", new Object[]{operand});
            if (oo != null) {
                for (Map.Entry entrySet : oo.getOptions().entrySet()) {
                    LOG.ok("OperationOptions {0}: {1}", new Object[]{entrySet.getKey(), entrySet.getValue()});
                }
            }
        }
        try {
            new CmdExecuteQuery(oc, this.cmdConfiguration, operand, rh).execQuery();
        }
        catch (ConnectException ex) {
            LOG.error("Error in connection process", new Object[]{ex});
        }
    }

    public FilterTranslator<Operand> createFilterTranslator(ObjectClass oc, OperationOptions oo) {
        if (oc == null || !oc.equals((Object)ObjectClass.ACCOUNT) && !oc.equals((Object)ObjectClass.GROUP)) {
            throw new IllegalArgumentException("Invalid objectclass");
        }
        return new CmdFilterTranslator();
    }
}

