/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit;

import java.time.LocalDateTime;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.inspektr.audit.AspectJAuditPointRuntimeInfo;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditPointRuntimeInfo;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.annotation.Audit;
import org.apereo.inspektr.audit.annotation.Audits;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.common.spi.AuditActionDateProvider;
import org.apereo.inspektr.common.spi.ClientInfoResolver;
import org.apereo.inspektr.common.spi.DefaultClientInfoResolver;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.apereo.inspektr.common.web.ClientInfo;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.Assert;

@Aspect
public class AuditTrailManagementAspect {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditTrailManagementAspect.class);
    private final PrincipalResolver defaultAuditPrincipalResolver;
    private final List<AuditTrailManager> auditTrailManagers;
    private final Map<String, AuditActionResolver> auditActionResolvers;
    private final Map<String, AuditResourceResolver> auditResourceResolvers;
    private final Map<String, PrincipalResolver> auditPrincipalResolvers;
    private final AuditTrailManager.AuditFormats auditFormat;
    private final AuditActionDateProvider auditActionDateProvider;
    private ClientInfoResolver clientInfoResolver = new DefaultClientInfoResolver();
    private boolean failOnAuditFailures = true;
    private boolean enabled = true;

    @Around(value="@annotation(audits)", argNames="audits")
    public Object handleAuditTrail(ProceedingJoinPoint joinPoint, Audits audits) throws Throwable {
        if (!this.enabled) {
            return joinPoint.proceed();
        }
        Object retVal = null;
        String currentPrincipal = null;
        String[] actions = new String[audits.value().length];
        String[][] auditableResources = new String[audits.value().length][];
        try {
            retVal = joinPoint.proceed();
            currentPrincipal = this.getCurrentPrincipal(joinPoint, audits, retVal);
            for (int i = 0; i < audits.value().length; ++i) {
                AuditActionResolver auditActionResolver = this.auditActionResolvers.get(audits.value()[i].actionResolverName());
                AuditResourceResolver auditResourceResolver = this.auditResourceResolvers.get(audits.value()[i].resourceResolverName());
                auditResourceResolver.setAuditFormat(this.auditFormat);
                auditableResources[i] = auditResourceResolver.resolveFrom((JoinPoint)joinPoint, retVal);
                actions[i] = auditActionResolver.resolveFrom((JoinPoint)joinPoint, retVal, audits.value()[i]);
            }
            Object i = retVal;
            return i;
        }
        catch (Throwable t) {
            Exception e = AuditTrailManagementAspect.wrapIfNecessary(t);
            currentPrincipal = this.getCurrentPrincipal(joinPoint, audits, (Object)e);
            if (currentPrincipal != null) {
                for (int i = 0; i < audits.value().length; ++i) {
                    AuditResourceResolver auditResourceResolver = this.auditResourceResolvers.get(audits.value()[i].resourceResolverName());
                    auditResourceResolver.setAuditFormat(this.auditFormat);
                    auditableResources[i] = auditResourceResolver.resolveFrom((JoinPoint)joinPoint, e);
                    actions[i] = this.auditActionResolvers.get(audits.value()[i].actionResolverName()).resolveFrom((JoinPoint)joinPoint, e, audits.value()[i]);
                }
            }
            throw t;
        }
        finally {
            for (int i = 0; i < audits.value().length; ++i) {
                this.executeAuditCode(currentPrincipal, auditableResources[i], joinPoint, retVal, actions[i]);
            }
        }
    }

    @Around(value="@annotation(audit)", argNames="audit")
    public Object handleAuditTrail(ProceedingJoinPoint joinPoint, Audit audit) throws Throwable {
        if (!this.enabled) {
            return joinPoint.proceed();
        }
        AuditActionResolver auditActionResolver = this.auditActionResolvers.get(audit.actionResolverName());
        Objects.requireNonNull(auditActionResolver, () -> "AuditActionResolver is undefined for %s".formatted(audit.actionResolverName()));
        AuditResourceResolver auditResourceResolver = this.auditResourceResolvers.get(audit.resourceResolverName());
        Objects.requireNonNull(auditResourceResolver, () -> "AuditActionResolver is undefined for %s".formatted(audit.actionResolverName()));
        auditResourceResolver.setAuditFormat(this.auditFormat);
        String currentPrincipal = null;
        String[] auditResource = new String[]{null};
        String action = null;
        Object retVal = null;
        try {
            retVal = joinPoint.proceed();
            currentPrincipal = this.getCurrentPrincipal(joinPoint, audit, retVal);
            auditResource = auditResourceResolver.resolveFrom((JoinPoint)joinPoint, retVal);
            action = auditActionResolver.resolveFrom((JoinPoint)joinPoint, retVal, audit);
            Object object = retVal;
            this.executeAuditCode(currentPrincipal, auditResource, joinPoint, retVal, action);
            return object;
        }
        catch (Throwable t) {
            try {
                Exception e = AuditTrailManagementAspect.wrapIfNecessary(t);
                currentPrincipal = this.getCurrentPrincipal(joinPoint, audit, (Object)e);
                auditResource = auditResourceResolver.resolveFrom((JoinPoint)joinPoint, e);
                action = auditActionResolver.resolveFrom((JoinPoint)joinPoint, e, audit);
                throw t;
            }
            catch (Throwable throwable) {
                this.executeAuditCode(currentPrincipal, auditResource, joinPoint, retVal, action);
                throw throwable;
            }
        }
    }

    private String getCurrentPrincipal(ProceedingJoinPoint joinPoint, Audits audits, Object retVal) {
        String currentPrincipal = null;
        for (int i = 0; i < audits.value().length; ++i) {
            String resolverName = audits.value()[i].principalResolverName();
            if (resolverName.trim().isEmpty()) continue;
            PrincipalResolver resolver = this.auditPrincipalResolvers.get(resolverName);
            currentPrincipal = resolver.resolveFrom((JoinPoint)joinPoint, retVal);
        }
        if (currentPrincipal == null) {
            currentPrincipal = this.defaultAuditPrincipalResolver.resolveFrom((JoinPoint)joinPoint, retVal);
        }
        return currentPrincipal;
    }

    private String getCurrentPrincipal(ProceedingJoinPoint joinPoint, Audit audit, Object retVal) {
        String currentPrincipal = null;
        String resolverName = audit.principalResolverName();
        if (!resolverName.trim().isEmpty()) {
            PrincipalResolver resolver = this.auditPrincipalResolvers.get(resolverName);
            currentPrincipal = resolver.resolveFrom((JoinPoint)joinPoint, retVal);
        }
        if (currentPrincipal == null) {
            currentPrincipal = this.defaultAuditPrincipalResolver.resolveFrom((JoinPoint)joinPoint, retVal);
        }
        return currentPrincipal;
    }

    private void executeAuditCode(String currentPrincipal, String[] auditableResources, ProceedingJoinPoint joinPoint, Object retVal, String action) {
        ClientInfo clientInfo = this.clientInfoResolver.resolveFrom((JoinPoint)joinPoint, retVal);
        LocalDateTime actionDate = (LocalDateTime)this.auditActionDateProvider.get();
        AspectJAuditPointRuntimeInfo runtimeInfo = new AspectJAuditPointRuntimeInfo((JoinPoint)joinPoint);
        Assert.notNull((Object)currentPrincipal, (String)("'principal' cannot be null.\n" + AuditTrailManagementAspect.getDiagnosticInfo(runtimeInfo)));
        Assert.notNull((Object)action, (String)("'actionPerformed' cannot be null.\n" + AuditTrailManagementAspect.getDiagnosticInfo(runtimeInfo)));
        Assert.notNull((Object)actionDate, (String)("'whenActionPerformed' cannot be null.\n" + AuditTrailManagementAspect.getDiagnosticInfo(runtimeInfo)));
        Assert.notNull((Object)clientInfo.getClientIpAddress(), (String)("'clientIpAddress' cannot be null.\n" + AuditTrailManagementAspect.getDiagnosticInfo(runtimeInfo)));
        Assert.notNull((Object)clientInfo.getServerIpAddress(), (String)("'serverIpAddress' cannot be null.\n" + AuditTrailManagementAspect.getDiagnosticInfo(runtimeInfo)));
        for (String auditableResource : auditableResources) {
            Assert.notNull((Object)auditableResource, (String)("'resourceOperatedUpon' cannot be null.\n" + AuditTrailManagementAspect.getDiagnosticInfo(runtimeInfo)));
            AuditActionContext auditContext = new AuditActionContext(currentPrincipal, auditableResource, action, "CAS", actionDate, clientInfo);
            try {
                for (AuditTrailManager manager : this.auditTrailManagers) {
                    manager.setAuditFormat(this.auditFormat);
                    manager.record(auditContext);
                }
            }
            catch (Throwable e) {
                if (this.failOnAuditFailures) {
                    throw e;
                }
                LOGGER.error("Failed to record audit context for [{}] and principal [{}]", (Object)auditContext.getActionPerformed(), (Object)auditContext.getPrincipal());
                LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            }
        }
    }

    private static String getDiagnosticInfo(AuditPointRuntimeInfo runtimeInfo) {
        return "Check the correctness of @Audit annotation at the following audit point: " + runtimeInfo.toString();
    }

    private static Exception wrapIfNecessary(Throwable throwable) {
        Exception ex;
        return throwable instanceof Exception ? (ex = (Exception)throwable) : new Exception(throwable);
    }

    @Generated
    public void setClientInfoResolver(ClientInfoResolver clientInfoResolver) {
        this.clientInfoResolver = clientInfoResolver;
    }

    @Generated
    public void setFailOnAuditFailures(boolean failOnAuditFailures) {
        this.failOnAuditFailures = failOnAuditFailures;
    }

    @Generated
    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Generated
    public AuditTrailManagementAspect(PrincipalResolver defaultAuditPrincipalResolver, List<AuditTrailManager> auditTrailManagers, Map<String, AuditActionResolver> auditActionResolvers, Map<String, AuditResourceResolver> auditResourceResolvers, Map<String, PrincipalResolver> auditPrincipalResolvers, AuditTrailManager.AuditFormats auditFormat, AuditActionDateProvider auditActionDateProvider) {
        this.defaultAuditPrincipalResolver = defaultAuditPrincipalResolver;
        this.auditTrailManagers = auditTrailManagers;
        this.auditActionResolvers = auditActionResolvers;
        this.auditResourceResolvers = auditResourceResolvers;
        this.auditPrincipalResolvers = auditPrincipalResolvers;
        this.auditFormat = auditFormat;
        this.auditActionDateProvider = auditActionDateProvider;
    }
}

