/*
 * Decompiled with CFR 0.152.
 */
package org.identityconnectors.framework.common.objects;

import java.util.HashMap;
import java.util.Objects;
import org.identityconnectors.common.Assertions;
import org.identityconnectors.framework.common.objects.ConnectorObject;
import org.identityconnectors.framework.common.objects.LiveSyncDelta;
import org.identityconnectors.framework.common.objects.ObjectClass;
import org.identityconnectors.framework.common.objects.SyncDeltaType;
import org.identityconnectors.framework.common.objects.SyncToken;
import org.identityconnectors.framework.common.objects.Uid;

public final class SyncDelta
extends LiveSyncDelta {
    private final SyncToken token;
    private final SyncDeltaType deltaType;
    private final Uid previousUid;

    SyncDelta(SyncToken token, SyncDeltaType deltaType, Uid previousUid, ObjectClass objectClass, Uid uid, ConnectorObject object) {
        super(objectClass, uid, object);
        Assertions.nullCheck(token, "token");
        Assertions.nullCheck((Object)deltaType, "deltaType");
        if (previousUid != null && (deltaType == SyncDeltaType.DELETE || deltaType == SyncDeltaType.CREATE)) {
            throw new IllegalArgumentException("The previous Uid can only be specified for create_or_update or update.");
        }
        if (object == null && deltaType != SyncDeltaType.DELETE) {
            throw new IllegalArgumentException("ConnectorObject must be specified for anything other than delete.");
        }
        this.token = token;
        this.deltaType = deltaType;
        this.previousUid = previousUid;
    }

    public Uid getPreviousUid() {
        return this.previousUid;
    }

    public SyncToken getToken() {
        return this.token;
    }

    public SyncDeltaType getDeltaType() {
        return this.deltaType;
    }

    @Override
    public String toString() {
        HashMap<String, Object> values = new HashMap<String, Object>();
        values.put("Token", this.token);
        values.put("DeltaType", (Object)this.deltaType);
        values.put("PreviousUid", this.previousUid);
        values.put("ObjectClass", this.getObjectClass());
        values.put("Uid", this.getUid());
        values.put("Object", this.getObject());
        return ((Object)values).toString();
    }

    @Override
    public int hashCode() {
        int hash = super.hashCode();
        hash = 89 * hash + Objects.hashCode(this.token);
        hash = 89 * hash + Objects.hashCode((Object)this.deltaType);
        hash = 89 * hash + Objects.hashCode(this.previousUid);
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SyncDelta other = (SyncDelta)obj;
        if (!super.equals(obj)) {
            return false;
        }
        if (!Objects.equals(this.token, other.token)) {
            return false;
        }
        if (this.deltaType != other.deltaType) {
            return false;
        }
        return Objects.equals(this.previousUid, other.previousUid);
    }
}

