/*
 * Decompiled with CFR 0.152.
 */
package org.apache.syncope.common.lib.scim;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.OffsetDateTime;
import java.util.Optional;

public class SCIMGeneralConf
implements Serializable {
    private static final long serialVersionUID = 3228349133950736647L;
    private OffsetDateTime creationDate = OffsetDateTime.now();
    private OffsetDateTime lastChangeDate = OffsetDateTime.now();
    private int bulkMaxOperations = 1000;
    private int bulkMaxPayloadSize = 0x100000;
    private int filterMaxResults = 200;

    public OffsetDateTime getCreationDate() {
        return this.creationDate;
    }

    public void setCreationDate(OffsetDateTime creationDate) {
        this.creationDate = creationDate;
    }

    public OffsetDateTime getLastChangeDate() {
        return this.lastChangeDate;
    }

    public void setLastChangeDate(OffsetDateTime lastChangeDate) {
        this.lastChangeDate = lastChangeDate;
    }

    @JsonIgnore
    public String getETagValue() {
        OffsetDateTime etagDate = this.getLastChangeDate() == null ? this.getCreationDate() : this.getLastChangeDate();
        return Optional.ofNullable(etagDate).map(date -> String.valueOf(date.toInstant().toEpochMilli())).orElse("");
    }

    public int getBulkMaxOperations() {
        return this.bulkMaxOperations;
    }

    public void setBulkMaxOperations(int bulkMaxOperations) {
        this.bulkMaxOperations = bulkMaxOperations;
    }

    public int getBulkMaxPayloadSize() {
        return this.bulkMaxPayloadSize;
    }

    public void setBulkMaxPayloadSize(int bulkMaxPayloadSize) {
        this.bulkMaxPayloadSize = bulkMaxPayloadSize;
    }

    public int getFilterMaxResults() {
        return this.filterMaxResults;
    }

    public void setFilterMaxResults(int filterMaxResults) {
        this.filterMaxResults = filterMaxResults;
    }
}

