/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.binding.collection;

import java.util.Collection;
import java.util.Map;
import org.springframework.binding.collection.MapAdaptable;
import org.springframework.util.Assert;

public class MapAccessor<K, V>
implements MapAdaptable<K, V> {
    private Map<K, V> map;

    public MapAccessor(Map<K, V> map) {
        Assert.notNull(map, (String)"The map to decorate is required");
        this.map = map;
    }

    @Override
    public Map<K, V> asMap() {
        return this.map;
    }

    public V get(Object key) {
        return this.map.get(key);
    }

    public V get(Object key, V defaultValue) {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return this.map.get(key);
    }

    public <T extends V> T get(Object key, Class<T> requiredType) throws IllegalArgumentException {
        return this.get(key, requiredType, null);
    }

    public <T extends V> T get(Object key, Class<T> requiredType, T defaultValue) {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return this.assertKeyValueOfType(key, requiredType);
    }

    public V getRequired(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return this.map.get(key);
    }

    public <T extends V> T getRequired(Object key, Class<T> requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return this.assertKeyValueOfType(key, requiredType);
    }

    public String getString(Object key) throws IllegalArgumentException {
        return this.getString(key, null);
    }

    public String getString(Object key, String defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return this.assertKeyValueOfType(key, String.class);
    }

    public String getRequiredString(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return this.assertKeyValueOfType(key, String.class);
    }

    public Collection<V> getCollection(Object key) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return null;
        }
        return this.assertKeyValueOfType(key, Collection.class);
    }

    public <T extends Collection<V>> T getCollection(Object key, Class<T> requiredType) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return null;
        }
        this.assertAssignableTo(Collection.class, requiredType);
        return (T)((Collection)this.assertKeyValueOfType(key, requiredType));
    }

    public Collection<V> getRequiredCollection(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return this.assertKeyValueOfType(key, Collection.class);
    }

    public <T extends Collection<V>> T getRequiredCollection(Object key, Class<T> requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        this.assertAssignableTo(Collection.class, requiredType);
        return (T)((Collection)this.assertKeyValueOfType(key, requiredType));
    }

    public <T extends V> T[] getArray(Object key, Class<? extends T[]> requiredType) throws IllegalArgumentException {
        this.assertAssignableTo(Object[].class, requiredType);
        if (!this.map.containsKey(key)) {
            return null;
        }
        return this.assertKeyValueOfType(key, requiredType);
    }

    public <T extends V> T[] getRequiredArray(Object key, Class<? extends T[]> requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        this.assertAssignableTo(Object[].class, requiredType);
        return this.assertKeyValueOfType(key, requiredType);
    }

    public <T extends Number> T getNumber(Object key, Class<T> requiredType) throws IllegalArgumentException {
        return this.getNumber(key, requiredType, null);
    }

    public <T extends Number> T getNumber(Object key, Class<T> requiredType, T defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        this.assertAssignableTo(Number.class, requiredType);
        return (T)((Number)this.assertKeyValueOfType(key, requiredType));
    }

    public <T extends Number> T getRequiredNumber(Object key, Class<T> requiredType) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return (T)((Number)this.assertKeyValueOfType(key, requiredType));
    }

    public Integer getInteger(Object key) throws IllegalArgumentException {
        return this.getInteger(key, null);
    }

    public Integer getInteger(Object key, Integer defaultValue) throws IllegalArgumentException {
        return this.getNumber(key, Integer.class, defaultValue);
    }

    public Integer getRequiredInteger(Object key) throws IllegalArgumentException {
        return this.getRequiredNumber(key, Integer.class);
    }

    public Long getLong(Object key) throws IllegalArgumentException {
        return this.getLong(key, null);
    }

    public Long getLong(Object key, Long defaultValue) throws IllegalArgumentException {
        return this.getNumber(key, Long.class, defaultValue);
    }

    public Long getRequiredLong(Object key) throws IllegalArgumentException {
        return this.getRequiredNumber(key, Long.class);
    }

    public Boolean getBoolean(Object key) throws IllegalArgumentException {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(Object key, Boolean defaultValue) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            return defaultValue;
        }
        return this.assertKeyValueOfType(key, Boolean.class);
    }

    public Boolean getRequiredBoolean(Object key) throws IllegalArgumentException {
        this.assertContainsKey(key);
        return this.assertKeyValueOfType(key, Boolean.class);
    }

    public void assertContainsKey(Object key) throws IllegalArgumentException {
        if (!this.map.containsKey(key)) {
            throw new IllegalArgumentException("Required attribute '" + key + "' is not present in map; attributes present are [" + this.asMap() + "]");
        }
    }

    public boolean containsKey(Object key, Class<?> requiredType) throws IllegalArgumentException {
        if (this.map.containsKey(key)) {
            this.assertKeyValueOfType(key, requiredType);
            return true;
        }
        return false;
    }

    public <T> T assertKeyValueOfType(Object key, Class<T> requiredType) {
        return this.assertKeyValueInstanceOf(key, this.map.get(key), requiredType);
    }

    public <T> T assertKeyValueInstanceOf(Object key, Object value, Class<T> requiredType) {
        Assert.notNull(requiredType, (String)"The required type to assert is required");
        if (value != null && !requiredType.isInstance(value)) {
            throw new IllegalArgumentException("Map key '" + key + "' has value [" + value + "] that is not of expected type [" + requiredType + "], instead it is of type [" + value.getClass().getName() + "]");
        }
        return (T)value;
    }

    private void assertAssignableTo(Class<?> clazz, Class<?> requiredType) {
        Assert.isTrue((boolean)clazz.isAssignableFrom(requiredType), (String)("The provided required type must be assignable to [" + clazz + "]"));
    }
}

