/*
 * Decompiled with CFR 0.152.
 */
package org.apache.orc.impl;

import com.github.luben.zstd.Zstd;
import com.github.luben.zstd.ZstdCompressCtx;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.orc.CompressionCodec;
import org.apache.orc.CompressionKind;
import org.apache.orc.impl.DirectDecompressionCodec;
import org.apache.orc.impl.OrcCodecPool;

public class ZstdCodec
implements CompressionCodec,
DirectDecompressionCodec {
    private ZstdOptions zstdOptions = null;
    private ZstdCompressCtx zstdCompressCtx = null;
    private static final ThreadLocal<byte[]> threadBuffer = ThreadLocal.withInitial(() -> null);
    private static final ZstdOptions DEFAULT_OPTIONS = new ZstdOptions(3, 0, 0);

    public ZstdCodec(int level, int windowLog, int strategy) {
        this.zstdOptions = new ZstdOptions(level, windowLog, strategy);
    }

    public ZstdCodec() {
        this(3, 0, 0);
    }

    public ZstdOptions getZstdOptions() {
        return this.zstdOptions;
    }

    protected static byte[] getBuffer(int size) {
        byte[] result = threadBuffer.get();
        if (result == null || result.length < size || result.length > size * 2) {
            result = new byte[size];
            threadBuffer.set(result);
        }
        return result;
    }

    @Override
    public CompressionCodec.Options getDefaultOptions() {
        return DEFAULT_OPTIONS.copy();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean compress(ByteBuffer in, ByteBuffer out, ByteBuffer overflow, CompressionCodec.Options options) throws IOException {
        int inBytes = in.remaining();
        if (inBytes < 10) {
            return false;
        }
        ZstdOptions zso = (ZstdOptions)options;
        this.zstdCompressCtx = new ZstdCompressCtx();
        this.zstdCompressCtx.setLevel(zso.level);
        this.zstdCompressCtx.setLong(zso.windowLog);
        this.zstdCompressCtx.setChecksum(false);
        this.zstdCompressCtx.setStrategy(zso.strategy);
        try {
            byte[] compressed = ZstdCodec.getBuffer((int)Zstd.compressBound((long)inBytes));
            int outBytes = this.zstdCompressCtx.compressByteArray(compressed, 0, compressed.length, in.array(), in.arrayOffset() + in.position(), inBytes);
            if (outBytes < inBytes) {
                int remaining = out.remaining();
                if (remaining >= outBytes) {
                    System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), outBytes);
                    out.position(out.position() + outBytes);
                } else {
                    System.arraycopy(compressed, 0, out.array(), out.arrayOffset() + out.position(), remaining);
                    out.position(out.limit());
                    System.arraycopy(compressed, remaining, overflow.array(), overflow.arrayOffset(), outBytes - remaining);
                    overflow.position(outBytes - remaining);
                }
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.zstdCompressCtx.close();
        }
    }

    @Override
    public void decompress(ByteBuffer in, ByteBuffer out) throws IOException {
        if (in.isDirect() && out.isDirect()) {
            this.directDecompress(in, out);
            return;
        }
        int srcOffset = in.arrayOffset() + in.position();
        int srcSize = in.remaining();
        int dstOffset = out.arrayOffset() + out.position();
        int dstSize = out.remaining() - dstOffset;
        long decompressOut = Zstd.decompressByteArray((byte[])out.array(), (int)dstOffset, (int)dstSize, (byte[])in.array(), (int)srcOffset, (int)srcSize);
        in.position(in.limit());
        out.position(dstOffset + (int)decompressOut);
        out.flip();
    }

    @Override
    public boolean isAvailable() {
        return true;
    }

    @Override
    public void directDecompress(ByteBuffer in, ByteBuffer out) throws IOException {
        Zstd.decompress((ByteBuffer)out, (ByteBuffer)in);
        out.flip();
    }

    @Override
    public void reset() {
    }

    @Override
    public void destroy() {
        if (this.zstdCompressCtx != null) {
            this.zstdCompressCtx.close();
        }
    }

    @Override
    public CompressionKind getKind() {
        return CompressionKind.ZSTD;
    }

    @Override
    public void close() {
        OrcCodecPool.returnCodec(CompressionKind.ZSTD, this);
    }

    static class ZstdOptions
    implements CompressionCodec.Options {
        private int level;
        private int windowLog;
        private int strategy;

        ZstdOptions(int level, int windowLog, int strategy) {
            this.level = level;
            this.windowLog = windowLog;
            this.strategy = strategy;
        }

        @Override
        public ZstdOptions copy() {
            return new ZstdOptions(this.level, this.windowLog, this.strategy);
        }

        @Override
        public CompressionCodec.Options setSpeed(CompressionCodec.SpeedModifier newValue) {
            return this;
        }

        public ZstdOptions setWindowLog(int newValue) {
            if ((newValue < Zstd.windowLogMin() || newValue > Zstd.windowLogMax()) && newValue != 0) {
                throw new IllegalArgumentException(String.format("Zstd compression window size should be in the range %d to %d, or set to the default value of 0.", Zstd.windowLogMin(), Zstd.windowLogMax()));
            }
            this.windowLog = newValue;
            return this;
        }

        public ZstdOptions setLevel(int newValue) {
            if (newValue < Zstd.minCompressionLevel() || newValue > Zstd.maxCompressionLevel()) {
                throw new IllegalArgumentException(String.format("Zstd compression level should be in the range %d to %d", Zstd.minCompressionLevel(), Zstd.maxCompressionLevel()));
            }
            this.level = newValue;
            return this;
        }

        public ZstdOptions setStrategy(int newValue) {
            this.strategy = newValue;
            return this;
        }

        @Override
        public ZstdOptions setData(CompressionCodec.DataKind newValue) {
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ZstdOptions that = (ZstdOptions)o;
            if (this.level != that.level) {
                return false;
            }
            if (this.strategy != that.strategy) {
                return false;
            }
            return this.windowLog == that.windowLog;
        }

        public int hashCode() {
            int result = this.level;
            result = 31 * result + this.windowLog;
            result = 31 * result + this.strategy;
            return result;
        }
    }
}

