/*
 * Decompiled with CFR 0.152.
 */
package com.aliyun.openservices.log.http.client;

import com.aliyun.openservices.log.Client;
import com.aliyun.openservices.log.common.Shard;
import com.aliyun.openservices.log.exception.LogException;
import com.aliyun.openservices.log.http.client.ClientConnectionStatus;
import com.aliyun.openservices.log.response.ListShardResponse;
import java.util.ArrayList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ClientConnectionContainer {
    private Client mClient = null;
    private ClientConnectionStatus mGlobalConnection = null;
    private Map<String, ClientConnectionStatus> mShardConnections = new ConcurrentHashMap<String, ClientConnectionStatus>();
    private Map<String, Long> mShardLastUpdateTime = new ConcurrentHashMap<String, Long>();
    private long mGlobalConnectionUpdateInterval = 30000000000L;
    private long mShardConnectionUpdateInterval = 300000000000L;
    private long mGlobalConnectionValidInterval = 60000000000L;
    private long mGlobalConnectionUpdateSendSize = 0x6400000L;

    public void Init(String endpoint, String accessId, String accessKey) {
        this.mClient = new Client(endpoint, accessId, accessKey);
    }

    public ClientConnectionStatus GetShardConnection(String project, String logstore, int shardId) {
        String keyShard;
        String key = project + "#" + logstore;
        if (!this.mShardLastUpdateTime.containsKey(key)) {
            this.mShardLastUpdateTime.put(key, 0L);
        }
        if (!this.mShardConnections.containsKey(keyShard = project + "#" + logstore + "#" + shardId)) {
            this.UpdateShardConnection(key);
        }
        if (this.mShardConnections.containsKey(keyShard)) {
            return this.mShardConnections.get(keyShard);
        }
        return null;
    }

    public void ResetGlobalConnection() {
        this.mGlobalConnection = null;
    }

    public ClientConnectionStatus GetGlobalConnection() {
        return this.mGlobalConnection;
    }

    public void UpdateConnections() {
        this.UpdateGlobalConnection();
        this.UpdateShardConnections();
    }

    public void UpdateGlobalConnection() {
        String ipAddress;
        long curTime = System.nanoTime();
        boolean toUpdate = false;
        if (this.mGlobalConnection == null || !this.mGlobalConnection.IsValidConnection()) {
            toUpdate = true;
        } else if (curTime - this.mGlobalConnection.GetLastUsedTime() < this.mGlobalConnectionValidInterval && (curTime - this.mGlobalConnection.GetCreateTime() > this.mGlobalConnectionUpdateInterval || this.mGlobalConnection.GetSendDataSize() > this.mGlobalConnectionUpdateSendSize || this.mGlobalConnection.GetPullDataSize() > this.mGlobalConnectionUpdateSendSize)) {
            toUpdate = true;
        }
        if (toUpdate && (ipAddress = this.mClient.GetServerIpAddress("")) != null && !ipAddress.isEmpty()) {
            this.mGlobalConnection = new ClientConnectionStatus(ipAddress);
        }
    }

    public void UpdateShardConnections() {
        for (Map.Entry<String, Long> entry : this.mShardLastUpdateTime.entrySet()) {
            String key = entry.getKey();
            this.UpdateShardConnection(key);
        }
    }

    private void UpdateShardConnection(String projectLogstore) {
        if (!this.mShardLastUpdateTime.containsKey(projectLogstore)) {
            return;
        }
        Long lastUpdateTime = this.mShardLastUpdateTime.get(projectLogstore);
        long curTime = System.nanoTime();
        if (curTime - lastUpdateTime < this.mShardConnectionUpdateInterval) {
            return;
        }
        String[] items = projectLogstore.split("#");
        if (items.length == 2) {
            try {
                ListShardResponse res = this.mClient.ListShard(items[0], items[1]);
                ArrayList<Shard> allShards = res.GetShards();
                for (Shard shard : allShards) {
                    String serverIp = shard.getServerIp();
                    if (serverIp == null || serverIp.isEmpty()) continue;
                    int shardId = shard.GetShardId();
                    String key = projectLogstore + "#" + shardId;
                    this.mShardConnections.put(key, new ClientConnectionStatus(serverIp));
                }
            }
            catch (LogException logException) {
                // empty catch block
            }
        }
        this.mShardLastUpdateTime.put(projectLogstore, curTime);
    }
}

