/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shenyu.plugin.cache;

import java.nio.charset.StandardCharsets;
import org.springframework.http.MediaType;
import org.springframework.web.server.ServerWebExchange;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;

public interface ICache {
    public Mono<Boolean> cacheData(String var1, byte[] var2, long var3);

    public Mono<Boolean> isExist(String var1);

    public Mono<byte[]> getData(String var1);

    default public void cacheContentType(String key, MediaType mediaType, long timeoutSeconds) {
        this.cacheData(key, this.mediaTypeToBytes(mediaType), timeoutSeconds).subscribeOn(Schedulers.boundedElastic()).subscribe();
    }

    default public byte[] mediaTypeToBytes(MediaType mediaType) {
        return mediaType.toString().getBytes(StandardCharsets.UTF_8);
    }

    default public void setContentType(ServerWebExchange exchange, byte[] contentTypeBytes) {
        if (contentTypeBytes.length == 0) {
            exchange.getResponse().getHeaders().setContentType(MediaType.APPLICATION_JSON);
        } else {
            exchange.getResponse().getHeaders().setContentType(MediaType.valueOf((String)new String(contentTypeBytes, StandardCharsets.UTF_8)));
        }
    }

    default public void close() {
    }
}

