/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.service;

import com.google.protobuf.Descriptors;
import io.grpc.reflection.v1alpha.DubboServerReflectionTriple;
import io.grpc.reflection.v1alpha.ErrorResponse;
import io.grpc.reflection.v1alpha.ExtensionNumberResponse;
import io.grpc.reflection.v1alpha.ExtensionRequest;
import io.grpc.reflection.v1alpha.FileDescriptorResponse;
import io.grpc.reflection.v1alpha.ListServiceResponse;
import io.grpc.reflection.v1alpha.ServerReflectionRequest;
import io.grpc.reflection.v1alpha.ServerReflectionResponse;
import io.grpc.reflection.v1alpha.ServiceResponse;
import java.util.ArrayDeque;
import java.util.HashSet;
import java.util.Set;
import org.apache.dubbo.common.stream.StreamObserver;
import org.apache.dubbo.rpc.TriRpcStatus;
import org.apache.dubbo.rpc.protocol.tri.service.SchemaDescriptorRegistry;

public class ReflectionV1AlphaService
extends DubboServerReflectionTriple.ServerReflectionImplBase {
    @Override
    public StreamObserver<ServerReflectionRequest> serverReflectionInfo(final StreamObserver<ServerReflectionResponse> responseObserver) {
        return new StreamObserver<ServerReflectionRequest>(){

            @Override
            public void onNext(ServerReflectionRequest request) {
                switch (request.getMessageRequestCase()) {
                    case FILE_BY_FILENAME: {
                        ReflectionV1AlphaService.this.getFileByName(request, responseObserver);
                        break;
                    }
                    case FILE_CONTAINING_SYMBOL: {
                        ReflectionV1AlphaService.this.getFileContainingSymbol(request, responseObserver);
                        break;
                    }
                    case FILE_CONTAINING_EXTENSION: {
                        ReflectionV1AlphaService.this.getFileByExtension(request, responseObserver);
                        break;
                    }
                    case ALL_EXTENSION_NUMBERS_OF_TYPE: {
                        ReflectionV1AlphaService.this.getAllExtensions(request, responseObserver);
                        break;
                    }
                    case LIST_SERVICES: {
                        ReflectionV1AlphaService.this.listServices(request, responseObserver);
                        break;
                    }
                    default: {
                        ReflectionV1AlphaService.this.sendErrorResponse(request, TriRpcStatus.Code.UNIMPLEMENTED, "not implemented " + (Object)((Object)request.getMessageRequestCase()), responseObserver);
                    }
                }
            }

            @Override
            public void onError(Throwable throwable) {
                responseObserver.onError(throwable);
            }

            @Override
            public void onCompleted() {
                responseObserver.onCompleted();
            }
        };
    }

    private void getFileByName(ServerReflectionRequest request, StreamObserver<ServerReflectionResponse> responseObserver) {
        String name = request.getFileByFilename();
        Descriptors.FileDescriptor fd = SchemaDescriptorRegistry.getSchemaDescriptor(name);
        if (fd != null) {
            responseObserver.onNext(this.createServerReflectionResponse(request, fd));
        } else {
            this.sendErrorResponse(request, TriRpcStatus.Code.NOT_FOUND, "File not found.", responseObserver);
        }
    }

    private void getFileContainingSymbol(ServerReflectionRequest request, StreamObserver<ServerReflectionResponse> responseObserver) {
        String symbol = request.getFileContainingSymbol();
        Descriptors.FileDescriptor fd = SchemaDescriptorRegistry.getSchemaDescriptor(symbol);
        if (fd != null) {
            responseObserver.onNext(this.createServerReflectionResponse(request, fd));
        } else {
            this.sendErrorResponse(request, TriRpcStatus.Code.NOT_FOUND, "Symbol not found.", responseObserver);
        }
    }

    private void getFileByExtension(ServerReflectionRequest request, StreamObserver<ServerReflectionResponse> responseObserver) {
        int extension;
        ExtensionRequest extensionRequest = request.getFileContainingExtension();
        String type = extensionRequest.getContainingType();
        Descriptors.FileDescriptor fd = SchemaDescriptorRegistry.getFileDescriptorByExtensionAndNumber(type, extension = extensionRequest.getExtensionNumber());
        if (fd != null) {
            responseObserver.onNext(this.createServerReflectionResponse(request, fd));
        } else {
            this.sendErrorResponse(request, TriRpcStatus.Code.NOT_FOUND, "Extension not found.", responseObserver);
        }
    }

    private void getAllExtensions(ServerReflectionRequest request, StreamObserver<ServerReflectionResponse> responseObserver) {
        String type = request.getAllExtensionNumbersOfType();
        Set<Integer> extensions = SchemaDescriptorRegistry.getExtensionNumbers(type);
        if (extensions != null) {
            ExtensionNumberResponse.Builder builder = ExtensionNumberResponse.newBuilder().setBaseTypeName(type).addAllExtensionNumber(extensions);
            responseObserver.onNext(ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setAllExtensionNumbersResponse(builder).build());
        } else {
            this.sendErrorResponse(request, TriRpcStatus.Code.NOT_FOUND, "Type not found.", responseObserver);
        }
    }

    private void listServices(ServerReflectionRequest request, StreamObserver<ServerReflectionResponse> responseObserver) {
        ListServiceResponse.Builder builder = ListServiceResponse.newBuilder();
        for (String serviceName : SchemaDescriptorRegistry.listServiceNames()) {
            builder.addService(ServiceResponse.newBuilder().setName(serviceName));
        }
        responseObserver.onNext(ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setListServicesResponse(builder).build());
    }

    private void sendErrorResponse(ServerReflectionRequest request, TriRpcStatus.Code code, String message, StreamObserver<ServerReflectionResponse> responseObserver) {
        ServerReflectionResponse response = ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setErrorResponse(ErrorResponse.newBuilder().setErrorCode(code.code).setErrorMessage(message)).build();
        responseObserver.onNext(response);
    }

    private ServerReflectionResponse createServerReflectionResponse(ServerReflectionRequest request, Descriptors.FileDescriptor fd) {
        FileDescriptorResponse.Builder fdRBuilder = FileDescriptorResponse.newBuilder();
        HashSet<String> seenFiles = new HashSet<String>();
        ArrayDeque<Descriptors.FileDescriptor> frontier = new ArrayDeque<Descriptors.FileDescriptor>();
        seenFiles.add(fd.getName());
        frontier.add(fd);
        while (!frontier.isEmpty()) {
            Descriptors.FileDescriptor nextFd = (Descriptors.FileDescriptor)frontier.remove();
            fdRBuilder.addFileDescriptorProto(nextFd.toProto().toByteString());
            for (Descriptors.FileDescriptor dependencyFd : nextFd.getDependencies()) {
                if (seenFiles.contains(dependencyFd.getName())) continue;
                seenFiles.add(dependencyFd.getName());
                frontier.add(dependencyFd);
            }
        }
        return ServerReflectionResponse.newBuilder().setValidHost(request.getHost()).setOriginalRequest(request).setFileDescriptorResponse(fdRBuilder).build();
    }
}

