/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.registry.nacos;

import com.alibaba.nacos.api.NacosFactory;
import com.alibaba.nacos.api.PropertyKeyConst;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.logger.ErrorTypeAwareLogger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.common.utils.StringConstantFieldValuePredicate;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.registry.nacos.util.NacosNamingServiceUtils;

public class NacosConnectionManager {
    private static final ErrorTypeAwareLogger logger = LoggerFactory.getErrorTypeAwareLogger(NacosNamingServiceUtils.class);
    private final URL connectionURL;
    private final List<NamingService> namingServiceList = new LinkedList<NamingService>();
    private final int retryTimes;
    private final int sleepMsBetweenRetries;
    private final boolean check;

    public NacosConnectionManager(URL connectionURL, boolean check, int retryTimes, int sleepMsBetweenRetries) {
        this.connectionURL = connectionURL;
        this.check = check;
        this.retryTimes = retryTimes;
        this.sleepMsBetweenRetries = sleepMsBetweenRetries;
        this.namingServiceList.add(this.createNamingService());
    }

    @Deprecated
    protected NacosConnectionManager(NamingService namingService) {
        this.connectionURL = null;
        this.retryTimes = 0;
        this.sleepMsBetweenRetries = 0;
        this.check = false;
        this.namingServiceList.add(namingService);
    }

    public synchronized NamingService getNamingService() {
        if (this.namingServiceList.isEmpty()) {
            this.namingServiceList.add(this.createNamingService());
        }
        return this.namingServiceList.get(ThreadLocalRandom.current().nextInt(this.namingServiceList.size()));
    }

    public synchronized NamingService getNamingService(Set<NamingService> selected) {
        LinkedList<NamingService> copyOfNamingService = new LinkedList<NamingService>(this.namingServiceList);
        copyOfNamingService.removeAll(selected);
        if (copyOfNamingService.isEmpty()) {
            this.namingServiceList.add(this.createNamingService());
            return this.getNamingService(selected);
        }
        return (NamingService)copyOfNamingService.get(ThreadLocalRandom.current().nextInt(copyOfNamingService.size()));
    }

    public synchronized void shutdownAll() {
        for (NamingService namingService : this.namingServiceList) {
            try {
                namingService.shutDown();
            }
            catch (Exception e) {
                logger.warn("1-37", "", "", "Unable to shutdown nacos naming service", e);
            }
        }
        this.namingServiceList.clear();
    }

    protected NamingService createNamingService() {
        Properties nacosProperties = this.buildNacosProperties(this.connectionURL);
        NamingService namingService = null;
        try {
            for (int i = 0; i < this.retryTimes + 1; ++i) {
                namingService = NacosFactory.createNamingService((Properties)nacosProperties);
                String serverStatus = namingService.getServerStatus();
                boolean namingServiceAvailable = this.testNamingService(namingService);
                if (!(!this.check || "UP".equals(serverStatus) && namingServiceAvailable)) {
                    logger.warn("1-37", "", "", "Failed to connect to nacos naming server. Server status: " + serverStatus + ". Naming Service Available: " + namingServiceAvailable + ". " + (i < this.retryTimes ? "Dubbo will try to retry in " + this.sleepMsBetweenRetries + ". " : "Exceed retry max times.") + "Try times: " + (i + 1));
                    namingService.shutDown();
                    namingService = null;
                    Thread.sleep(this.sleepMsBetweenRetries);
                    continue;
                }
                break;
            }
        }
        catch (NacosException e) {
            if (logger.isErrorEnabled()) {
                logger.error("1-37", "", "", e.getErrMsg(), e);
            }
        }
        catch (InterruptedException e) {
            logger.error("99-1", "", "", "Interrupted when creating nacos naming service client.", e);
            Thread.currentThread().interrupt();
            throw new IllegalStateException(e);
        }
        if (namingService == null) {
            logger.error("1-37", "", "", "Failed to create nacos naming service client. Reason: server status check failed.");
            throw new IllegalStateException("Failed to create nacos naming service client. Reason: server status check failed.");
        }
        return namingService;
    }

    private boolean testNamingService(NamingService namingService) {
        try {
            namingService.getAllInstances("Dubbo-Nacos-Test", false);
            return true;
        }
        catch (NacosException e) {
            return false;
        }
    }

    private Properties buildNacosProperties(URL url) {
        Properties properties = new Properties();
        this.setServerAddr(url, properties);
        this.setProperties(url, properties);
        return properties;
    }

    private void setServerAddr(URL url, Properties properties) {
        StringBuilder serverAddrBuilder = new StringBuilder(url.getHost()).append(':').append(url.getPort());
        String backup = url.getParameter("backup");
        if (StringUtils.isNotEmpty(backup)) {
            serverAddrBuilder.append(',').append(backup);
        }
        String serverAddr = serverAddrBuilder.toString();
        properties.put("serverAddr", serverAddr);
    }

    private void setProperties(URL url, Properties properties) {
        this.putPropertyIfAbsent(url, properties, "com.alibaba.nacos.naming.log.filename", null);
        Map<String, String> parameters = url.getParameters(StringConstantFieldValuePredicate.of(PropertyKeyConst.class));
        properties.putAll(parameters);
        if (StringUtils.isNotEmpty(url.getUsername())) {
            properties.put("username", url.getUsername());
        }
        if (StringUtils.isNotEmpty(url.getPassword())) {
            properties.put("password", url.getPassword());
        }
    }

    private void putPropertyIfAbsent(URL url, Properties properties, String propertyName, String defaultValue) {
        String propertyValue = url.getParameter(propertyName);
        if (StringUtils.isNotEmpty(propertyValue)) {
            properties.setProperty(propertyName, propertyValue);
        } else if (StringUtils.isNotEmpty(defaultValue)) {
            properties.setProperty(propertyName, defaultValue);
        }
    }
}

