/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.sofa.rpc.registry.multicast;

import com.alipay.sofa.rpc.client.ProviderGroup;
import com.alipay.sofa.rpc.client.ProviderHelper;
import com.alipay.sofa.rpc.client.ProviderInfo;
import com.alipay.sofa.rpc.common.struct.NamedThreadFactory;
import com.alipay.sofa.rpc.common.utils.CommonUtils;
import com.alipay.sofa.rpc.common.utils.NetUtils;
import com.alipay.sofa.rpc.common.utils.StringUtils;
import com.alipay.sofa.rpc.config.ConsumerConfig;
import com.alipay.sofa.rpc.config.ProviderConfig;
import com.alipay.sofa.rpc.config.RegistryConfig;
import com.alipay.sofa.rpc.config.ServerConfig;
import com.alipay.sofa.rpc.core.exception.SofaRpcRuntimeException;
import com.alipay.sofa.rpc.event.ConsumerSubEvent;
import com.alipay.sofa.rpc.event.EventBus;
import com.alipay.sofa.rpc.event.ProviderPubEvent;
import com.alipay.sofa.rpc.ext.Extension;
import com.alipay.sofa.rpc.listener.ProviderInfoListener;
import com.alipay.sofa.rpc.log.LogCodes;
import com.alipay.sofa.rpc.log.Logger;
import com.alipay.sofa.rpc.log.LoggerFactory;
import com.alipay.sofa.rpc.registry.Registry;
import com.alipay.sofa.rpc.registry.multicast.MulticastRegistryHelper;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.MulticastSocket;
import java.net.Socket;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;

@Extension(value="multicast")
public class MulticastRegistry
extends Registry {
    private static final Logger LOGGER = LoggerFactory.getLogger(MulticastRegistry.class);
    private static final int DEFAULT_MULTICAST_PORT = 1234;
    private static final String EXT_NAME = "multicast";
    private static final String SPACE = " ";
    private static final String REGISTER = "register";
    private static final String UNREGISTER = "unregister";
    private static final String SUBSCRIBE = "subscribe";
    private static final String UNSUBSCRIBE = "unsubscribe";
    private static final String CLEAN_PERIOD = "cleanPeriod";
    private static final String CLEAN = "clean";
    private InetAddress multicastAddress;
    private MulticastSocket multicastSocket;
    private int multicastPort;
    protected Map<String, ProviderGroup> allProviderCache = new ConcurrentHashMap<String, ProviderGroup>();
    protected Map<String, List<ConsumerConfig>> notifyListeners = new ConcurrentHashMap<String, List<ConsumerConfig>>();
    protected Map<String, ProviderGroup> registeredCache = new ConcurrentHashMap<String, ProviderGroup>();
    private ScheduledExecutorService cleanExecutor = new ScheduledThreadPoolExecutor(1, new NamedThreadFactory("SofaMulticastRegistryCleanTimer", true));
    private ScheduledFuture<?> cleanFuture;
    private int cleanPeriod = 60000;

    protected MulticastRegistry(RegistryConfig registryConfig) {
        super(registryConfig);
    }

    @Override
    public boolean start() {
        if (this.multicastSocket == null) {
            LOGGER.warn("Please invoke MulticastRegistry.init() first!");
            return false;
        }
        return true;
    }

    @Override
    public void register(ProviderConfig config) {
        List<ServerConfig> serverConfigs;
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return;
        }
        if (config.isRegister() && CommonUtils.isNotEmpty(serverConfigs = config.getServer())) {
            for (ServerConfig server : serverConfigs) {
                String serviceName = MulticastRegistryHelper.buildListDataId(config, server.getProtocol());
                ProviderInfo providerInfo = MulticastRegistryHelper.convertProviderToProviderInfo(config, server);
                if (LOGGER.isInfoEnabled(appName)) {
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010000003", serviceName));
                }
                this.doRegister(appName, serviceName, providerInfo);
                if (!LOGGER.isInfoEnabled(appName)) continue;
                LOGGER.infoWithApp(appName, LogCodes.getLog("010000004", serviceName));
            }
            if (EventBus.isEnable(ProviderPubEvent.class)) {
                ProviderPubEvent event = new ProviderPubEvent(config);
                EventBus.post(event);
            }
        }
    }

    @Override
    public void unRegister(ProviderConfig config) {
        List<ServerConfig> serverConfigs;
        String appName = config.getAppName();
        if (!this.registryConfig.isRegister()) {
            if (LOGGER.isInfoEnabled(appName)) {
                LOGGER.infoWithApp(appName, LogCodes.getLog("010060003"));
            }
            return;
        }
        if (config.isRegister() && CommonUtils.isNotEmpty(serverConfigs = config.getServer())) {
            for (ServerConfig server : serverConfigs) {
                String serviceName = MulticastRegistryHelper.buildListDataId(config, server.getProtocol());
                ProviderInfo providerInfo = MulticastRegistryHelper.convertProviderToProviderInfo(config, server);
                try {
                    this.doUnRegister(serviceName, providerInfo);
                    if (!LOGGER.isInfoEnabled(appName)) continue;
                    LOGGER.infoWithApp(appName, LogCodes.getLog("010000002", serviceName, "1"));
                }
                catch (Exception e) {
                    LOGGER.errorWithApp(appName, LogCodes.getLog("010000002", serviceName, "0"), e);
                }
            }
        }
    }

    @Override
    public void batchUnRegister(List<ProviderConfig> configs) {
        for (ProviderConfig config : configs) {
            String appName = config.getAppName();
            try {
                this.unRegister(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Error when batch unregistry", e);
            }
        }
    }

    @Override
    public List<ProviderGroup> subscribe(ConsumerConfig config) {
        if (!config.isSubscribe()) {
            return null;
        }
        String key = MulticastRegistryHelper.buildListDataId(config, config.getProtocol());
        List<ConsumerConfig> listeners = this.notifyListeners.get(key);
        if (listeners == null) {
            listeners = new ArrayList<ConsumerConfig>();
            this.notifyListeners.put(key, listeners);
        }
        listeners.add(config);
        this.multicast(SUBSCRIBE + key);
        ProviderGroup group = this.allProviderCache.get(key);
        if (group == null) {
            group = new ProviderGroup();
            this.allProviderCache.put(key, group);
        }
        if (EventBus.isEnable(ConsumerSubEvent.class)) {
            ConsumerSubEvent event = new ConsumerSubEvent(config);
            EventBus.post(event);
        }
        return Collections.singletonList(group);
    }

    @Override
    public void unSubscribe(ConsumerConfig config) {
        if (!config.isSubscribe()) {
            return;
        }
        String key = MulticastRegistryHelper.buildListDataId(config, config.getProtocol());
        this.notifyListeners.remove(key);
    }

    @Override
    public void batchUnSubscribe(List<ConsumerConfig> configs) {
        for (ConsumerConfig config : configs) {
            String appName = config.getAppName();
            try {
                this.unSubscribe(config);
            }
            catch (Exception e) {
                LOGGER.errorWithApp(appName, "Error when batch unSubscribe", e);
            }
        }
    }

    @Override
    public void destroy() {
        try {
            this.multicastSocket.leaveGroup(this.multicastAddress);
            this.multicastSocket.close();
            this.multicastSocket = null;
            if (this.cleanFuture != null && !this.cleanFuture.isCancelled()) {
                this.cleanFuture.cancel(true);
            }
        }
        catch (Throwable t) {
            LOGGER.warn(t.getMessage(), t);
        }
    }

    @Override
    public void init() {
        if (this.multicastSocket != null) {
            return;
        }
        String addressInput = this.registryConfig.getAddress();
        if (StringUtils.isEmpty(addressInput)) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010060021", EXT_NAME));
        }
        try {
            if (!addressInput.startsWith(EXT_NAME)) {
                addressInput = "multicast://" + addressInput;
            }
            URI url = new URI(addressInput);
            this.multicastPort = url.getPort();
            if (this.multicastPort <= 0) {
                this.multicastPort = 1234;
            }
            this.multicastAddress = InetAddress.getByName(url.getHost());
            MulticastRegistryHelper.checkMulticastAddress(this.multicastAddress);
            this.multicastSocket = new MulticastSocket(this.multicastPort);
            NetUtils.joinMulticastGroup(this.multicastSocket, this.multicastAddress);
            Thread thread = new Thread(new Runnable(){

                @Override
                public void run() {
                    byte[] buf = new byte[2048];
                    DatagramPacket recv = new DatagramPacket(buf, buf.length);
                    while (!MulticastRegistry.this.multicastSocket.isClosed()) {
                        try {
                            MulticastRegistry.this.multicastSocket.receive(recv);
                            String msg = new String(recv.getData()).trim();
                            int i = msg.indexOf(10);
                            if (i > 0) {
                                msg = msg.substring(0, i).trim();
                            }
                            MulticastRegistry.this.receive(msg, (InetSocketAddress)recv.getSocketAddress());
                            Arrays.fill(buf, (byte)0);
                        }
                        catch (Throwable e) {
                            if (MulticastRegistry.this.multicastSocket.isClosed()) continue;
                            LOGGER.error(e.getMessage(), e);
                        }
                    }
                }
            }, "SofaMulticastRegistryReceiver");
            thread.setDaemon(true);
            thread.start();
        }
        catch (Exception e) {
            throw new SofaRpcRuntimeException(LogCodes.getLog("010060029", EXT_NAME), e);
        }
        String cleanPeriodStr = this.registryConfig.getParameter(CLEAN_PERIOD);
        if (StringUtils.isNotBlank(cleanPeriodStr)) {
            this.cleanPeriod = Integer.parseInt(cleanPeriodStr);
        }
        this.cleanFuture = !Boolean.FALSE.toString().equalsIgnoreCase(this.registryConfig.getParameter(CLEAN)) ? this.cleanExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    MulticastRegistry.this.clean();
                }
                catch (Throwable t) {
                    LOGGER.error("Unexpected exception occur at clean expired provider, cause: " + t.getMessage(), t);
                }
            }
        }, this.cleanPeriod, this.cleanPeriod, TimeUnit.MILLISECONDS) : null;
    }

    private void clean() {
        Map<String, ProviderGroup> allProviderCache = this.allProviderCache;
        for (Map.Entry<String, ProviderGroup> entry : allProviderCache.entrySet()) {
            List<ProviderInfo> providerInfos = entry.getValue().getProviderInfos();
            if (!CommonUtils.isNotEmpty(providerInfos)) continue;
            for (ProviderInfo providerInfo : providerInfos) {
                if (!this.isExpired(providerInfo)) continue;
                if (LOGGER.isWarnEnabled()) {
                    LOGGER.warn("Clean expired provider " + providerInfos);
                }
                this.doUnRegister(entry.getKey(), providerInfo);
            }
        }
    }

    private boolean isExpired(ProviderInfo providerInfo) {
        try {
            Socket socket = new Socket(providerInfo.getHost(), providerInfo.getPort());
            Throwable throwable = null;
            if (socket != null) {
                if (throwable != null) {
                    try {
                        socket.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                } else {
                    socket.close();
                }
            }
        }
        catch (Throwable e) {
            try {
                Thread.sleep(100L);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            try {
                Socket socket2 = new Socket(providerInfo.getHost(), providerInfo.getPort());
                Throwable throwable = null;
                if (socket2 != null) {
                    if (throwable != null) {
                        try {
                            socket2.close();
                        }
                        catch (Throwable throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                    } else {
                        socket2.close();
                    }
                }
            }
            catch (Throwable e2) {
                return true;
            }
        }
        return false;
    }

    private void receive(String msg, InetSocketAddress remoteAddress) {
        String serviceName;
        ProviderGroup providerGroup;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Receive multicast message: " + msg + " from " + remoteAddress);
        }
        if (msg.startsWith(REGISTER)) {
            String[] split = msg.split(SPACE);
            if (split.length != 3) {
                LOGGER.error("Receive error REGISTER :" + msg);
                return;
            }
            String serviceName2 = split[1];
            String providerInfoUrl = split[2];
            this.receiveRegister(serviceName2, providerInfoUrl);
        } else if (msg.startsWith(UNREGISTER)) {
            String[] split = msg.split(SPACE);
            if (split.length != 3) {
                LOGGER.error("Receive error REGISTER :" + msg);
                return;
            }
            String serviceName3 = split[1];
            String providerInfoUrl = split[2];
            this.receiveUnregistered(serviceName3, providerInfoUrl);
        } else if (msg.startsWith(SUBSCRIBE) && (providerGroup = this.registeredCache.get(serviceName = msg.substring(SUBSCRIBE.length()).trim())) != null && !providerGroup.isEmpty()) {
            for (ProviderInfo providerInfo : providerGroup.getProviderInfos()) {
                String providerInfoUrl = ProviderHelper.toUrl(providerInfo);
                String regStr = StringUtils.join(new String[]{REGISTER, serviceName, providerInfoUrl}, SPACE);
                this.multicast(regStr);
            }
        }
    }

    private void receiveRegister(String serviceName, String providerInfoUrl) {
        ProviderInfo providerInfo = ProviderHelper.toProviderInfo(providerInfoUrl);
        ProviderGroup providerGroup = this.addToCache(serviceName, providerInfo, this.allProviderCache);
        this.notifyConsumerListeners(serviceName, providerGroup);
    }

    private void receiveUnregistered(String serviceName, String providerInfoUrl) {
        ProviderInfo providerInfo = ProviderHelper.toProviderInfo(providerInfoUrl);
        this.removeFromCache(serviceName, providerInfo, this.allProviderCache);
    }

    private ProviderGroup removeFromCache(String serviceName, ProviderInfo providerInfo, Map<String, ProviderGroup> cache) {
        ProviderGroup oldGroup = cache.get(serviceName);
        if (oldGroup != null) {
            oldGroup.remove(providerInfo);
        }
        return oldGroup;
    }

    private void multicast(String msg) {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("Send multicast message: " + msg + " to " + this.multicastAddress + ":" + this.multicastPort);
        }
        try {
            byte[] data = (msg + "\n").getBytes();
            DatagramPacket hi = new DatagramPacket(data, data.length, this.multicastAddress, this.multicastPort);
            this.multicastSocket.send(hi);
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage(), e);
        }
    }

    private void doRegister(String appName, String serviceName, ProviderInfo providerInfo) {
        if (LOGGER.isInfoEnabled(appName)) {
            LOGGER.infoWithApp(appName, LogCodes.getLog("010000001", serviceName));
        }
        this.addToCache(serviceName, providerInfo, this.allProviderCache);
        String regStr = StringUtils.join(new String[]{REGISTER, serviceName, ProviderHelper.toUrl(providerInfo)}, SPACE);
        this.multicast(regStr);
        this.addToCache(serviceName, providerInfo, this.registeredCache);
        this.notifyConsumerListeners(serviceName, this.allProviderCache.get(serviceName));
    }

    private ProviderGroup addToCache(String serviceName, ProviderInfo providerInfo, Map<String, ProviderGroup> cache) {
        ProviderGroup oldGroup = cache.get(serviceName);
        if (oldGroup != null) {
            oldGroup.add(providerInfo);
        } else {
            ArrayList<ProviderInfo> news = new ArrayList<ProviderInfo>();
            news.add(providerInfo);
            cache.put(serviceName, new ProviderGroup(news));
        }
        return oldGroup;
    }

    private void doUnRegister(String serviceName, ProviderInfo providerInfo) {
        this.removeFromCache(serviceName, providerInfo, this.allProviderCache);
        this.removeFromCache(serviceName, providerInfo, this.registeredCache);
        String unregStr = StringUtils.join(new String[]{UNREGISTER, serviceName, ProviderHelper.toUrl(providerInfo)}, SPACE);
        this.multicast(unregStr);
        this.notifyConsumerListeners(serviceName, this.allProviderCache.get(serviceName));
    }

    private void notifyConsumerListeners(String serviceName, ProviderGroup providerGroup) {
        List<ConsumerConfig> consumerConfigs = this.notifyListeners.get(serviceName);
        if (consumerConfigs != null) {
            for (ConsumerConfig config : consumerConfigs) {
                ProviderInfoListener listener = config.getProviderInfoListener();
                if (listener == null) continue;
                listener.updateProviders(providerGroup);
            }
        }
    }

    public Map<String, ProviderGroup> getAllProviderCache() {
        return this.allProviderCache;
    }
}

