/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.server.util;

import java.util.List;
import java.util.function.Function;
import org.apache.ratis.proto.RaftProtos;
import org.apache.ratis.protocol.RaftGroupMemberId;
import org.apache.ratis.server.protocol.TermIndex;
import org.apache.ratis.server.raftlog.LogProtoUtils;
import org.apache.ratis.util.JavaUtils;
import org.apache.ratis.util.ProtoUtils;

public final class ServerStringUtils {
    private ServerStringUtils() {
    }

    public static String toAppendEntriesRequestString(RaftProtos.AppendEntriesRequestProto request, Function<RaftProtos.StateMachineLogEntryProto, String> stateMachineToString) {
        if (request == null) {
            return null;
        }
        List<RaftProtos.LogEntryProto> entries = request.getEntriesList();
        return ProtoUtils.toString(request.getServerRequest()) + "-t" + request.getLeaderTerm() + ",previous=" + TermIndex.valueOf(request.getPreviousLog()) + ",leaderCommit=" + request.getLeaderCommit() + ",initializing? " + request.getInitializing() + "," + (entries.isEmpty() ? "HEARTBEAT" : "entries: " + LogProtoUtils.toLogEntriesShortString(entries, stateMachineToString));
    }

    public static String toAppendEntriesReplyString(RaftProtos.AppendEntriesReplyProto reply) {
        if (reply == null) {
            return null;
        }
        return ProtoUtils.toString(reply.getServerReply()) + "-t" + reply.getTerm() + "," + reply.getResult() + ",nextIndex=" + reply.getNextIndex() + ",followerCommit=" + reply.getFollowerCommit() + ",matchIndex=" + reply.getMatchIndex();
    }

    public static String toInstallSnapshotRequestString(RaftProtos.InstallSnapshotRequestProto request) {
        String s2;
        if (request == null) {
            return null;
        }
        switch (request.getInstallSnapshotRequestBodyCase()) {
            case SNAPSHOTCHUNK: {
                RaftProtos.InstallSnapshotRequestProto.SnapshotChunkProto chunk = request.getSnapshotChunk();
                s2 = "chunk:" + chunk.getRequestId() + "," + chunk.getRequestIndex();
                break;
            }
            case NOTIFICATION: {
                RaftProtos.InstallSnapshotRequestProto.NotificationProto notification = request.getNotification();
                s2 = "notify:" + TermIndex.valueOf(notification.getFirstAvailableTermIndex());
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected body case in " + request);
            }
        }
        return ProtoUtils.toString(request.getServerRequest()) + "-t" + request.getLeaderTerm() + "," + s2;
    }

    public static String toInstallSnapshotReplyString(RaftProtos.InstallSnapshotReplyProto reply) {
        String s2;
        if (reply == null) {
            return null;
        }
        switch (reply.getInstallSnapshotReplyBodyCase()) {
            case REQUESTINDEX: {
                s2 = ",requestIndex=" + reply.getRequestIndex();
                break;
            }
            case SNAPSHOTINDEX: {
                s2 = ",snapshotIndex=" + reply.getSnapshotIndex();
                break;
            }
            default: {
                s2 = "";
            }
        }
        return ProtoUtils.toString(reply.getServerReply()) + "-t" + reply.getTerm() + "," + reply.getResult() + s2;
    }

    public static String toRequestVoteReplyString(RaftProtos.RequestVoteReplyProto proto) {
        if (proto == null) {
            return null;
        }
        return ProtoUtils.toString(proto.getServerReply()) + "-t" + proto.getTerm() + "-last:" + TermIndex.valueOf(proto.getLastEntry());
    }

    public static String generateUnifiedName(RaftGroupMemberId memberId, Class<?> clazz) {
        return memberId + "-" + JavaUtils.getClassSimpleName(clazz);
    }
}

