/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.security;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import javax.net.ssl.TrustManager;
import org.apache.qpid.server.configuration.IllegalConfigurationException;
import org.apache.qpid.server.model.Broker;
import org.apache.qpid.server.model.ConfiguredObject;
import org.apache.qpid.server.model.ManagedAttributeField;
import org.apache.qpid.server.model.ManagedObject;
import org.apache.qpid.server.model.ManagedObjectFactoryConstructor;
import org.apache.qpid.server.model.State;
import org.apache.qpid.server.model.StateTransition;
import org.apache.qpid.server.security.AbstractTrustStore;
import org.apache.qpid.server.security.NonJavaTrustStore;
import org.apache.qpid.server.transport.network.security.ssl.SSLUtil;
import org.apache.qpid.server.util.urlstreamhandler.data.Handler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ManagedObject(category=false)
public class NonJavaTrustStoreImpl
extends AbstractTrustStore<NonJavaTrustStoreImpl>
implements NonJavaTrustStore<NonJavaTrustStoreImpl> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NonJavaTrustStoreImpl.class);
    @ManagedAttributeField(afterSet="initialize")
    private String _certificatesUrl;
    private volatile TrustManager[] _trustManagers = new TrustManager[0];
    private X509Certificate[] _certificates;

    @ManagedObjectFactoryConstructor
    public NonJavaTrustStoreImpl(Map<String, Object> attributes, Broker<?> broker) {
        super(attributes, broker);
    }

    @Override
    public String getCertificatesUrl() {
        return this._certificatesUrl;
    }

    @Override
    protected TrustManager[] getTrustManagersInternal() throws GeneralSecurityException {
        TrustManager[] trustManagers = this._trustManagers;
        if (trustManagers == null || trustManagers.length == 0) {
            throw new IllegalStateException("Truststore " + String.valueOf(this) + " defines no trust managers");
        }
        return Arrays.copyOf(trustManagers, trustManagers.length);
    }

    @Override
    public Certificate[] getCertificates() throws GeneralSecurityException {
        Certificate[] certificates = this._certificates;
        return certificates == null ? new X509Certificate[]{} : certificates;
    }

    @Override
    public void onValidate() {
        super.onValidate();
        this.validateTrustStoreAttributes(this);
    }

    @StateTransition(currentState={State.UNINITIALIZED, State.ERRORED}, desiredState=State.ACTIVE)
    protected CompletableFuture<Void> doActivate() {
        this.initializeExpiryChecking();
        this.setState(State.ACTIVE);
        return CompletableFuture.completedFuture(null);
    }

    @Override
    protected void validateChange(ConfiguredObject<?> proxyForValidation, Set<String> changedAttributes) {
        super.validateChange(proxyForValidation, changedAttributes);
        NonJavaTrustStore changedStore = (NonJavaTrustStore)proxyForValidation;
        this.validateTrustStoreAttributes(changedStore);
    }

    private void validateTrustStoreAttributes(NonJavaTrustStore<?> keyStore) {
        try {
            SSLUtil.readCertificates(NonJavaTrustStoreImpl.getUrlFromString(keyStore.getCertificatesUrl()));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException("Cannot validate certificate(s):" + String.valueOf(e), e);
        }
    }

    @Override
    protected void initialize() {
        try {
            if (this._certificatesUrl != null) {
                X509Certificate[] certs = SSLUtil.readCertificates(NonJavaTrustStoreImpl.getUrlFromString(this._certificatesUrl));
                KeyStore inMemoryKeyStore = KeyStore.getInstance(KeyStore.getDefaultType());
                inMemoryKeyStore.load(null, null);
                int i = 1;
                for (X509Certificate cert : certs) {
                    inMemoryKeyStore.setCertificateEntry(String.valueOf(i++), cert);
                }
                this._trustManagers = this.getTrustManagers(inMemoryKeyStore);
                this._certificates = certs;
            }
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalConfigurationException("Cannot load certificate(s) :" + String.valueOf(e), e);
        }
    }

    static {
        Handler.register();
    }
}

