/*
 * Decompiled with CFR 0.152.
 */
package org.apache.qpid.server.query.engine.validation;

import java.util.List;
import org.apache.qpid.server.query.engine.exception.QueryParsingException;
import org.apache.qpid.server.query.engine.parsing.expression.ExpressionNode;
import org.apache.qpid.server.query.engine.parsing.expression.function.AbstractFunctionExpression;

public final class FunctionParametersValidator {
    private FunctionParametersValidator() {
    }

    public static <T, R> void requireParameters(int size, List<ExpressionNode<T, ?>> args, AbstractFunctionExpression<T, R> expression) {
        String errorMessage;
        String string = errorMessage = size > 1 ? "Function '%s' requires %d parameters" : "Function '%s' requires %d parameter";
        if (args == null || args.isEmpty()) {
            throw QueryParsingException.of(errorMessage, expression.getFunctionName(), size);
        }
        if (args.size() != size) {
            throw QueryParsingException.of(errorMessage, expression.getFunctionName(), size);
        }
    }

    public static <T, R> void requireMinParameters(int size, List<ExpressionNode<T, ?>> args, AbstractFunctionExpression<T, R> expression) {
        String errorMessage;
        String string = errorMessage = size > 1 ? "Function '%s' requires at least %d parameters" : "Function '%s' requires at least %d parameter";
        if (args == null || args.isEmpty()) {
            throw QueryParsingException.of(errorMessage, expression.getFunctionName(), size);
        }
        if (args.size() < size) {
            throw QueryParsingException.of(errorMessage, expression.getFunctionName(), size);
        }
    }

    public static <T, R> void requireMaxParameters(int size, List<ExpressionNode<T, ?>> args, AbstractFunctionExpression<T, R> expression) {
        if (args == null || args.isEmpty()) {
            throw QueryParsingException.of("Function '%s' requires maximum %d parameters", expression.getFunctionName(), size);
        }
        if (args.size() > size) {
            throw QueryParsingException.of("Function '%s' requires maximum %d parameters", expression.getFunctionName(), size);
        }
    }
}

