/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.instrumentation.runtimemetrics.java8;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.api.common.Attributes;
import io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.api.metrics.ObservableLongMeasurement;
import io.opentelemetry.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.instrumentation.runtimemetrics.java8.internal.JmxRuntimeMetricsUtil;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public final class Threads {
    static final Threads INSTANCE;
    static final AttributeKey<Boolean> DAEMON;
    static final AttributeKey<Boolean> JVM_THREAD_DAEMON;
    static final AttributeKey<String> JVM_THREAD_STATE;
    @Nullable
    private static final MethodHandle THREAD_INFO_IS_DAEMON;

    public static List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry) {
        return INSTANCE.registerObservers(openTelemetry, ManagementFactory.getThreadMXBean());
    }

    List<AutoCloseable> registerObservers(OpenTelemetry openTelemetry, ThreadMXBean threadBean) {
        Meter meter = JmxRuntimeMetricsUtil.getMeter(openTelemetry);
        ArrayList<AutoCloseable> observables = new ArrayList<AutoCloseable>();
        if (SemconvStability.emitOldJvmSemconv()) {
            observables.add((AutoCloseable)meter.upDownCounterBuilder("process.runtime.jvm.threads.count").setDescription("Number of executing threads").setUnit("{thread}").buildWithCallback(observableMeasurement -> {
                int daemonThreadCount = threadBean.getDaemonThreadCount();
                observableMeasurement.record((long)daemonThreadCount, Attributes.builder().put(DAEMON, (Object)true).build());
                observableMeasurement.record((long)(threadBean.getThreadCount() - daemonThreadCount), Attributes.builder().put(DAEMON, (Object)false).build());
            }));
        }
        if (SemconvStability.emitStableJvmSemconv()) {
            observables.add((AutoCloseable)meter.upDownCounterBuilder("jvm.thread.count").setDescription("Number of executing platform threads.").setUnit("{thread}").buildWithCallback(Threads.isJava9OrNewer() ? Threads.java9AndNewerCallback(threadBean) : Threads.java8Callback(threadBean)));
        }
        return observables;
    }

    private static boolean isJava9OrNewer() {
        return THREAD_INFO_IS_DAEMON != null;
    }

    private static Consumer<ObservableLongMeasurement> java8Callback(ThreadMXBean threadBean) {
        return measurement -> {
            int daemonThreadCount = threadBean.getDaemonThreadCount();
            measurement.record((long)daemonThreadCount, Attributes.builder().put(JVM_THREAD_DAEMON, (Object)true).build());
            measurement.record((long)(threadBean.getThreadCount() - daemonThreadCount), Attributes.builder().put(JVM_THREAD_DAEMON, (Object)false).build());
        };
    }

    private static Consumer<ObservableLongMeasurement> java9AndNewerCallback(ThreadMXBean threadBean) {
        return measurement -> {
            HashMap<Attributes, Long> counts = new HashMap<Attributes, Long>();
            long[] threadIds = threadBean.getAllThreadIds();
            for (ThreadInfo threadInfo : threadBean.getThreadInfo(threadIds)) {
                if (threadInfo == null) continue;
                Attributes threadAttributes2 = Threads.threadAttributes(threadInfo);
                counts.compute(threadAttributes2, (k, value) -> value == null ? 1L : value + 1L);
            }
            counts.forEach((threadAttributes, count) -> measurement.record(count.longValue(), threadAttributes));
        };
    }

    private static Attributes threadAttributes(ThreadInfo threadInfo) {
        boolean isDaemon;
        try {
            isDaemon = Objects.requireNonNull(THREAD_INFO_IS_DAEMON).invoke(threadInfo);
        }
        catch (Throwable e) {
            throw new IllegalStateException("Unexpected error happened during ThreadInfo#isDaemon()", e);
        }
        String threadState = threadInfo.getThreadState().name().toLowerCase(Locale.ROOT);
        return Attributes.of(JVM_THREAD_DAEMON, (Object)isDaemon, JVM_THREAD_STATE, (Object)threadState);
    }

    private Threads() {
    }

    static {
        MethodHandle isDaemon;
        INSTANCE = new Threads();
        DAEMON = AttributeKey.booleanKey((String)"daemon");
        JVM_THREAD_DAEMON = AttributeKey.booleanKey((String)"jvm.thread.daemon");
        JVM_THREAD_STATE = AttributeKey.stringKey((String)"jvm.thread.state");
        try {
            isDaemon = MethodHandles.publicLookup().findVirtual(ThreadInfo.class, "isDaemon", MethodType.methodType(Boolean.TYPE));
        }
        catch (IllegalAccessException | NoSuchMethodException e) {
            isDaemon = null;
        }
        THREAD_INFO_IS_DAEMON = isDaemon;
    }
}

