/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.cling.invoker.mvnup.goals;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import org.apache.maven.api.cli.mvnup.UpgradeOptions;
import org.apache.maven.api.di.Inject;
import org.apache.maven.cling.invoker.mvnup.Goal;
import org.apache.maven.cling.invoker.mvnup.UpgradeContext;
import org.apache.maven.cling.invoker.mvnup.goals.ModelVersionUtils;
import org.apache.maven.cling.invoker.mvnup.goals.PomDiscovery;
import org.apache.maven.cling.invoker.mvnup.goals.StrategyOrchestrator;
import org.apache.maven.cling.invoker.mvnup.goals.UpgradeResult;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;

public abstract class AbstractUpgradeGoal
implements Goal {
    private final StrategyOrchestrator orchestrator;

    @Inject
    public AbstractUpgradeGoal(StrategyOrchestrator orchestrator) {
        this.orchestrator = orchestrator;
    }

    @Override
    public int execute(UpgradeContext context) throws Exception {
        Map<Path, Document> pomMap;
        UpgradeOptions options = context.options();
        String targetModel = options.modelVersion().isPresent() ? (String)options.modelVersion().get() : (options.all().orElse(false) != false ? "4.1.0" : "4.0.0");
        if (!ModelVersionUtils.isValidModelVersion(targetModel)) {
            context.failure("Invalid target model version: " + targetModel);
            context.failure("Supported versions: 4.0.0, 4.1.0");
            return 1;
        }
        context.info("Discovering POM files...");
        Path startingDirectory = options.directory().map(x$0 -> Paths.get(x$0, new String[0])).orElse(context.invokerRequest.cwd());
        try {
            pomMap = PomDiscovery.discoverPoms(startingDirectory);
        }
        catch (IOException | JDOMException e) {
            context.failure("Failed to discover POM files: " + e.getMessage());
            return 1;
        }
        if (pomMap.isEmpty()) {
            context.warning("No POM files found in " + String.valueOf(startingDirectory));
            return 0;
        }
        context.info("Found " + pomMap.size() + " POM file(s)");
        int result = this.doUpgrade(context, targetModel, pomMap);
        if (this.shouldSaveModifications() && result == 0) {
            this.saveModifications(context, pomMap);
        }
        return result;
    }

    protected int doUpgrade(UpgradeContext context, String targetModel, Map<Path, Document> pomMap) {
        try {
            UpgradeResult result = this.orchestrator.executeStrategies(context, pomMap);
            this.createMvnDirectoryIfNeeded(context);
            return result.success() ? 0 : 1;
        }
        catch (Exception e) {
            context.failure("Strategy execution failed: " + e.getMessage());
            return 1;
        }
    }

    protected abstract boolean shouldSaveModifications();

    protected void saveModifications(UpgradeContext context, Map<Path, Document> pomMap) {
        context.info("");
        context.info("Saving modified POMs...");
        for (Map.Entry<Path, Document> entry : pomMap.entrySet()) {
            Path pomPath = entry.getKey();
            Document document = entry.getValue();
            try {
                ByteArrayOutputStream output;
                String content = Files.readString(entry.getKey(), StandardCharsets.UTF_8);
                int startIndex = content.indexOf("<" + document.getRootElement().getName());
                String head = startIndex >= 0 ? content.substring(0, startIndex) : "";
                String lastTag = document.getRootElement().getName() + ">";
                int endIndex = content.lastIndexOf(lastTag);
                String tail = endIndex >= 0 ? content.substring(endIndex + lastTag.length()) : "";
                Format format = Format.getRawFormat();
                format.setLineSeparator(System.lineSeparator());
                XMLOutputter out = new XMLOutputter(format);
                try (ByteArrayOutputStream outputStream = output = new ByteArrayOutputStream();){
                    outputStream.write(head.getBytes(StandardCharsets.UTF_8));
                    out.output(document.getRootElement(), (OutputStream)outputStream);
                    outputStream.write(tail.getBytes(StandardCharsets.UTF_8));
                }
                String newBody = output.toString(StandardCharsets.UTF_8);
                Files.writeString(pomPath, (CharSequence)newBody, StandardCharsets.UTF_8, new OpenOption[0]);
            }
            catch (Exception e) {
                context.failure("Failed to save " + String.valueOf(pomPath) + ": " + e.getMessage());
            }
        }
    }

    protected void createMvnDirectoryIfNeeded(UpgradeContext context) {
        context.info("");
        context.info("Creating .mvn directory if needed to avoid root directory warnings...");
        Path startingDirectory = context.options().directory().map(x$0 -> Paths.get(x$0, new String[0])).orElse(context.invokerRequest.cwd());
        Path mvnDir = startingDirectory.resolve(".mvn");
        try {
            if (!Files.exists(mvnDir, new LinkOption[0])) {
                if (this.shouldSaveModifications()) {
                    Files.createDirectories(mvnDir, new FileAttribute[0]);
                    context.success("Created .mvn directory at " + String.valueOf(mvnDir));
                } else {
                    context.action("Would create .mvn directory at " + String.valueOf(mvnDir));
                }
            } else {
                context.success(".mvn directory already exists at " + String.valueOf(mvnDir));
            }
        }
        catch (Exception e) {
            context.failure("Failed to create .mvn directory: " + e.getMessage());
        }
    }
}

