/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.namefind;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import opennlp.tools.namefind.TokenNameFinder;
import opennlp.tools.util.Span;

public final class RegexNameFinder
implements TokenNameFinder {
    private Pattern[] mPatterns;
    private String sType;
    private Map<String, Pattern[]> regexMap;

    public RegexNameFinder(Map<String, Pattern[]> regexMap) {
        this.regexMap = Objects.requireNonNull(regexMap, "regexMap must not be null");
    }

    public RegexNameFinder(Pattern[] patterns, String type) {
        if (patterns == null || patterns.length == 0) {
            throw new IllegalArgumentException("patterns must not be null or empty!");
        }
        this.mPatterns = patterns;
        this.sType = type;
    }

    @Override
    public Span[] find(String[] tokens) {
        HashMap<Integer, Integer> sentencePosTokenMap = new HashMap<Integer, Integer>();
        StringBuilder sentenceString = new StringBuilder(tokens.length * 10);
        for (int i = 0; i < tokens.length; ++i) {
            int startIndex = sentenceString.length();
            sentencePosTokenMap.put(startIndex, i);
            sentenceString.append(tokens[i]);
            int endIndex = sentenceString.length();
            sentencePosTokenMap.put(endIndex, i + 1);
            if (i >= tokens.length - 1) continue;
            sentenceString.append(' ');
        }
        LinkedList<Span> annotations = new LinkedList<Span>();
        if (this.regexMap != null) {
            for (Map.Entry<String, Pattern[]> entry : this.regexMap.entrySet()) {
                for (Pattern mPattern : entry.getValue()) {
                    Matcher matcher = mPattern.matcher(sentenceString);
                    while (matcher.find()) {
                        Integer tokenStartIndex = (Integer)sentencePosTokenMap.get(matcher.start());
                        Integer tokenEndIndex = (Integer)sentencePosTokenMap.get(matcher.end());
                        if (tokenStartIndex == null || tokenEndIndex == null) continue;
                        Span annotation = new Span((int)tokenStartIndex, (int)tokenEndIndex, entry.getKey());
                        annotations.add(annotation);
                    }
                }
            }
        } else {
            for (Pattern mPattern : this.mPatterns) {
                Matcher matcher = mPattern.matcher(sentenceString);
                while (matcher.find()) {
                    Integer tokenStartIndex = (Integer)sentencePosTokenMap.get(matcher.start());
                    Integer tokenEndIndex = (Integer)sentencePosTokenMap.get(matcher.end());
                    if (tokenStartIndex == null || tokenEndIndex == null) continue;
                    Span annotation = new Span((int)tokenStartIndex, (int)tokenEndIndex, this.sType);
                    annotations.add(annotation);
                }
            }
        }
        return annotations.toArray(new Span[0]);
    }

    public Span[] find(String text) {
        return this.getAnnotations(text);
    }

    private Span[] getAnnotations(String text) {
        LinkedList<Span> annotations = new LinkedList<Span>();
        if (this.regexMap != null) {
            for (Map.Entry<String, Pattern[]> entry : this.regexMap.entrySet()) {
                for (Pattern mPattern : entry.getValue()) {
                    Matcher matcher = mPattern.matcher(text);
                    while (matcher.find()) {
                        Span annotation = new Span(matcher.start(), matcher.end(), entry.getKey());
                        annotations.add(annotation);
                    }
                }
            }
        } else {
            for (Pattern mPattern : this.mPatterns) {
                Matcher matcher = mPattern.matcher(text);
                while (matcher.find()) {
                    Span annotation = new Span(matcher.start(), matcher.end(), this.sType);
                    annotations.add(annotation);
                }
            }
        }
        return annotations.toArray(new Span[0]);
    }

    @Override
    public void clearAdaptiveData() {
    }

    public Pattern[] getMatchingPatterns() {
        return this.mPatterns;
    }

    public void setMatchingPatterns(Pattern[] mPatterns) {
        this.mPatterns = mPatterns;
    }

    public String getSpanType() {
        return this.sType;
    }

    public void setSpanType(String sType) {
        this.sType = sType;
    }
}

