/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jena.tdb1.store.tupletable;

import java.util.Iterator;
import java.util.function.Predicate;
import org.apache.jena.atlas.iterator.Iter;
import org.apache.jena.atlas.lib.Closeable;
import org.apache.jena.atlas.lib.Sync;
import org.apache.jena.atlas.lib.tuple.Tuple;
import org.apache.jena.tdb1.lib.ColumnMap;
import org.apache.jena.tdb1.store.NodeId;

public interface TupleIndex
extends Sync,
Closeable {
    public boolean add(Tuple<NodeId> var1);

    public boolean delete(Tuple<NodeId> var1);

    public String getName();

    public String getMappingStr();

    public ColumnMap getColumnMap();

    public Iterator<Tuple<NodeId>> find(Tuple<NodeId> var1);

    public Iterator<Tuple<NodeId>> all();

    public int weight(Tuple<NodeId> var1);

    public int getTupleLength();

    public long size();

    public boolean isEmpty();

    public void clear();

    public static Iterator<Tuple<NodeId>> scan(Iterator<Tuple<NodeId>> iter, final Tuple<NodeId> pattern) {
        final int tupleLength = pattern.len();
        Predicate<Tuple<NodeId>> filter = new Predicate<Tuple<NodeId>>(){

            @Override
            public boolean test(Tuple<NodeId> item) {
                for (int i = 0; i < tupleLength; ++i) {
                    NodeId n = (NodeId)pattern.get(i);
                    if (NodeId.isAny(n) || ((NodeId)item.get(i)).equals(n)) continue;
                    return false;
                }
                return true;
            }
        };
        return Iter.filter(iter, (Predicate)filter);
    }
}

