/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.visor.util;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.cache.configuration.Factory;
import org.apache.ignite.IgniteLogger;
import org.apache.ignite.cache.eviction.AbstractEvictionPolicyFactory;
import org.apache.ignite.cluster.ClusterNode;
import org.apache.ignite.internal.IgniteEx;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxy;
import org.apache.ignite.internal.processors.cache.IgniteCacheProxyImpl;
import org.apache.ignite.internal.util.IgniteUtils;
import org.apache.ignite.internal.util.typedef.F;
import org.apache.ignite.internal.util.typedef.X;
import org.apache.ignite.internal.util.typedef.internal.SB;
import org.apache.ignite.internal.util.typedef.internal.U;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VisorTaskUtils {
    @Nullable
    public static String compactClass(Class cls) {
        if (cls == null) {
            return null;
        }
        return U.compact(cls.getName());
    }

    @Nullable
    public static String compactClass(@Nullable Object obj) {
        if (obj == null) {
            return null;
        }
        return VisorTaskUtils.compactClass(obj.getClass());
    }

    @Nullable
    public static List<String> compactClasses(Class<?>[] clss) {
        if (clss == null) {
            return null;
        }
        int len = clss.length;
        ArrayList<String> res = new ArrayList<String>(len);
        for (Class<?> cls : clss) {
            res.add(U.compact(cls.getName()));
        }
        return res;
    }

    @Nullable
    public static String compactIterable(Iterable col) {
        if (col == null || !col.iterator().hasNext()) {
            return null;
        }
        String sep = ", ";
        StringBuilder sb = new StringBuilder();
        for (Object s : col) {
            sb.append(s).append(sep);
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - sep.length());
        }
        return U.compact(sb.toString());
    }

    public static Integer evictionPolicyMaxSize(@Nullable Factory plc) {
        if (plc instanceof AbstractEvictionPolicyFactory) {
            return ((AbstractEvictionPolicyFactory)plc).getMaxSize();
        }
        return null;
    }

    private static String formatDuration(long ms) {
        long min;
        long hh;
        assert (ms >= 0L);
        if (ms == 0L) {
            return "< 1 ms";
        }
        SB sb = new SB();
        long dd = ms / 1440000L;
        if (dd > 0L) {
            sb.a(dd).a(dd == 1L ? " day " : " days ");
        }
        if ((hh = (ms %= 1440000L) / 60000L) > 0L) {
            sb.a(hh).a(hh == 1L ? " hour " : " hours ");
        }
        if ((min = ms / 60000L) > 0L) {
            sb.a(min).a(min == 1L ? " min " : " mins ");
        }
        if ((ms %= 60000L) > 0L) {
            sb.a(ms).a(" ms ");
        }
        return sb.toString().trim();
    }

    private static void log0(@Nullable IgniteLogger log, long time, String msg) {
        if (log != null) {
            if (log.isDebugEnabled()) {
                log.debug(msg);
            } else {
                log.warning(msg);
            }
        } else {
            X.println(String.format("[%s][%s]%s", IgniteUtils.DEBUG_DATE_FMT.format(Instant.ofEpochMilli(time)), Thread.currentThread().getName(), msg), new Object[0]);
        }
    }

    public static void logStart(@Nullable IgniteLogger log, Class<?> clazz, long start) {
        VisorTaskUtils.log0(log, start, "[" + clazz.getSimpleName() + "]: STARTED");
    }

    public static void logFinish(@Nullable IgniteLogger log, Class<?> clazz, long start) {
        long end = System.currentTimeMillis();
        VisorTaskUtils.log0(log, end, String.format("[%s]: FINISHED, duration: %s", clazz.getSimpleName(), VisorTaskUtils.formatDuration(end - start)));
    }

    public static void logMapped(@Nullable IgniteLogger log, Class<?> clazz, Collection<ClusterNode> nodes) {
        VisorTaskUtils.log0(log, System.currentTimeMillis(), String.format("[%s]: MAPPED: %s", clazz.getSimpleName(), U.toShortString(nodes)));
    }

    public static long log(@Nullable IgniteLogger log, String msg, Class<?> clazz, long start) {
        long end = System.currentTimeMillis();
        VisorTaskUtils.log0(log, end, String.format("[%s]: %s, duration: %s", clazz.getSimpleName(), msg, VisorTaskUtils.formatDuration(end - start)));
        return end;
    }

    public static boolean isRestartingCache(IgniteEx ignite, String cacheName) {
        IgniteCacheProxy proxy = ignite.context().cache().jcache(cacheName);
        return proxy instanceof IgniteCacheProxyImpl && ((IgniteCacheProxyImpl)proxy).isRestarting();
    }

    public static class SortableAddress
    implements Comparable<SortableAddress> {
        private int type;
        private BigDecimal bits;
        private String addr;

        public SortableAddress(String addr) {
            this.addr = addr;
            if (addr.indexOf(58) > 0) {
                this.type = 4;
            } else {
                try {
                    InetAddress inetAddr = InetAddress.getByName(addr);
                    this.type = inetAddr.isLoopbackAddress() ? 3 : (inetAddr.isSiteLocalAddress() ? 2 : 1);
                }
                catch (UnknownHostException ignored) {
                    this.type = 5;
                }
            }
            this.bits = BigDecimal.valueOf(0L);
            try {
                String[] octets = addr.contains(".") ? addr.split(".") : addr.split(":");
                int len = octets.length;
                for (int i = 0; i < len; ++i) {
                    long oct = F.isEmpty(octets[i]) ? 0L : Long.valueOf(octets[i]);
                    long pow = Double.valueOf(Math.pow(256.0, octets.length - 1 - i)).longValue();
                    this.bits = this.bits.add(BigDecimal.valueOf(oct * pow));
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        @Override
        public int compareTo(@NotNull SortableAddress o) {
            return this.type == o.type ? this.bits.compareTo(o.bits) : Integer.compare(this.type, o.type);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortableAddress other = (SortableAddress)o;
            return this.addr != null ? this.addr.equals(other.addr) : other.addr == null;
        }

        public int hashCode() {
            return this.addr != null ? this.addr.hashCode() : 0;
        }

        public String address() {
            return this.addr;
        }
    }
}

