/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.util.tostring;

import java.lang.reflect.Field;
import org.apache.ignite.internal.util.GridUnsafe;

class GridToStringFieldDescriptor {
    public static final int FIELD_TYPE_OBJECT = 0;
    public static final int FIELD_TYPE_BYTE = 1;
    public static final int FIELD_TYPE_BOOLEAN = 2;
    public static final int FIELD_TYPE_CHAR = 3;
    public static final int FIELD_TYPE_SHORT = 4;
    public static final int FIELD_TYPE_INT = 5;
    public static final int FIELD_TYPE_FLOAT = 6;
    public static final int FIELD_TYPE_LONG = 7;
    public static final int FIELD_TYPE_DOUBLE = 8;
    private final String name;
    private int order = Integer.MAX_VALUE;
    private final long off;
    private final int type;
    private final Class<?> cls;

    GridToStringFieldDescriptor(Field field) {
        assert ((field.getModifiers() & 8) == 0) : "Static fields are not allowed here: " + field;
        this.off = GridUnsafe.objectFieldOffset(field);
        this.cls = field.getType();
        this.name = field.getName();
        if (!this.cls.isPrimitive()) {
            this.type = 0;
        } else if (this.cls == Byte.TYPE) {
            this.type = 1;
        } else if (this.cls == Boolean.TYPE) {
            this.type = 2;
        } else if (this.cls == Character.TYPE) {
            this.type = 3;
        } else if (this.cls == Short.TYPE) {
            this.type = 4;
        } else if (this.cls == Integer.TYPE) {
            this.type = 5;
        } else if (this.cls == Float.TYPE) {
            this.type = 6;
        } else if (this.cls == Long.TYPE) {
            this.type = 7;
        } else if (this.cls == Double.TYPE) {
            this.type = 8;
        } else {
            throw new IllegalArgumentException("Unexpected primitive type: " + this.cls);
        }
    }

    int getOrder() {
        return this.order;
    }

    void setOrder(int order) {
        this.order = order;
    }

    public long offset() {
        return this.off;
    }

    public int type() {
        return this.type;
    }

    public Class<?> fieldClass() {
        return this.cls;
    }

    String getName() {
        return this.name;
    }
}

