/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.mr.hive.plan;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.plan.CustomBucketFunction;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ConstantObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.PrimitiveObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.IntObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.typeinfo.PrimitiveTypeInfo;
import org.apache.hadoop.hive.serde2.typeinfo.TypeInfoFactory;
import org.apache.hadoop.io.IntWritable;
import org.apache.iceberg.mr.hive.udf.GenericUDFIcebergBucket;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;

public class IcebergBucketFunction
implements CustomBucketFunction {
    private static final long serialVersionUID = 1L;
    private final List<String> sourceColumnNames;
    private final List<Integer> numBuckets;
    private transient List<GenericUDFIcebergBucket> bucketUdfs;
    private transient List<IntObjectInspector> bucketIdInspectors;
    private transient GenericUDF.SettableDeferredJavaObject[] deferredObjects;

    public IcebergBucketFunction(List<String> sourceColumnNames, List<Integer> numBuckets) {
        Objects.requireNonNull(sourceColumnNames);
        Objects.requireNonNull(numBuckets);
        Preconditions.checkArgument(sourceColumnNames.size() == numBuckets.size());
        Preconditions.checkArgument(!sourceColumnNames.isEmpty());
        this.sourceColumnNames = sourceColumnNames;
        this.numBuckets = numBuckets;
    }

    public Optional<CustomBucketFunction> select(boolean[] retainedColumns) {
        Preconditions.checkArgument(retainedColumns.length == this.numBuckets.size());
        Preconditions.checkState(this.bucketUdfs == null);
        Preconditions.checkState(this.bucketIdInspectors == null);
        Preconditions.checkState(this.deferredObjects == null);
        ArrayList<String> newSourceColumnNames = Lists.newArrayList();
        ArrayList<Integer> newNumBuckets = Lists.newArrayList();
        for (int i = 0; i < retainedColumns.length; ++i) {
            if (!retainedColumns[i]) continue;
            newSourceColumnNames.add(this.sourceColumnNames.get(i));
            newNumBuckets.add(this.numBuckets.get(i));
        }
        if (newSourceColumnNames.isEmpty()) {
            return Optional.empty();
        }
        IcebergBucketFunction newBucketFunction = new IcebergBucketFunction(newSourceColumnNames, newNumBuckets);
        return Optional.of(newBucketFunction);
    }

    public void initialize(ObjectInspector[] objectInspectors) {
        Preconditions.checkArgument(objectInspectors.length == this.numBuckets.size());
        this.bucketIdInspectors = Lists.newArrayList();
        this.bucketUdfs = Lists.newArrayList();
        for (int i = 0; i < objectInspectors.length; ++i) {
            GenericUDFIcebergBucket udf = new GenericUDFIcebergBucket();
            ConstantObjectInspector numBucketInspector = PrimitiveObjectInspectorFactory.getPrimitiveWritableConstantObjectInspector((PrimitiveTypeInfo)TypeInfoFactory.intTypeInfo, (Object)new IntWritable(this.numBuckets.get(i).intValue()));
            ObjectInspector[] args = new ObjectInspector[]{objectInspectors[i], numBucketInspector};
            try {
                ObjectInspector inspector = udf.initialize(args);
                Preconditions.checkState(inspector.getCategory() == ObjectInspector.Category.PRIMITIVE);
                PrimitiveObjectInspector primitiveInspector = (PrimitiveObjectInspector)inspector;
                Preconditions.checkState(primitiveInspector.getPrimitiveCategory() == PrimitiveObjectInspector.PrimitiveCategory.INT);
                this.bucketIdInspectors.add((IntObjectInspector)primitiveInspector);
            }
            catch (UDFArgumentException e) {
                throw new IllegalArgumentException("The given object inspector is illegal", e);
            }
            this.bucketUdfs.add(udf);
        }
        this.deferredObjects = new GenericUDF.SettableDeferredJavaObject[1];
        this.deferredObjects[0] = new GenericUDF.SettableDeferredJavaObject();
        Preconditions.checkState(this.bucketIdInspectors.size() == this.numBuckets.size());
        Preconditions.checkState(this.bucketUdfs.size() == this.numBuckets.size());
    }

    public List<String> getSourceColumnNames() {
        return this.sourceColumnNames;
    }

    public int getNumBuckets() {
        return this.numBuckets.stream().reduce(1, Math::multiplyExact);
    }

    public int getBucketHashCode(Object[] bucketFields) {
        int[] bucketIds = new int[this.numBuckets.size()];
        for (int i = 0; i < this.bucketUdfs.size(); ++i) {
            this.deferredObjects[0].set(bucketFields[i]);
            try {
                Object bucketId = this.bucketUdfs.get(i).evaluate((GenericUDF.DeferredObject[])this.deferredObjects);
                bucketIds[i] = this.bucketIdInspectors.get(i).get(bucketId);
                continue;
            }
            catch (HiveException e) {
                throw new IllegalArgumentException("Failed to evaluate the given objects", e);
            }
        }
        return IcebergBucketFunction.getHashCode(bucketIds);
    }

    public static int getHashCode(int[] bucketIds) {
        int hashCode = 0;
        for (int bucketId : bucketIds) {
            hashCode = 31 * hashCode + bucketId;
        }
        return hashCode;
    }

    public String toString() {
        return String.format("IcebergBucketFunction{sourceColumnNames=%s,numBuckets=%s}", this.sourceColumnNames, this.numBuckets);
    }
}

