/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql.udf.generic;

import java.time.ZoneId;
import java.time.ZoneOffset;
import java.util.List;
import org.apache.hadoop.hive.ql.exec.UDFArgumentException;
import org.apache.hadoop.hive.ql.exec.UDFArgumentTypeException;
import org.apache.hadoop.hive.ql.metadata.HiveException;
import org.apache.hadoop.hive.ql.udf.generic.GenericUDF;
import org.apache.hadoop.hive.serde2.objectinspector.ObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.StructObjectInspector;
import org.apache.hadoop.hive.serde2.objectinspector.primitive.PrimitiveObjectInspectorFactory;
import org.apache.hadoop.hive.serde2.variant.Variant;

public class GenericUDFToJson
extends GenericUDF {
    private StructObjectInspector inputOI;

    @Override
    public ObjectInspector initialize(ObjectInspector[] arguments) throws UDFArgumentException {
        if (arguments.length != 1) {
            throw new UDFArgumentException("to_json takes exactly 1 argument");
        }
        if (!(arguments[0] instanceof StructObjectInspector)) {
            throw new UDFArgumentTypeException(0, "Argument must be VARIANT (struct<metadata:binary,value:binary>)");
        }
        this.inputOI = (StructObjectInspector)arguments[0];
        return PrimitiveObjectInspectorFactory.javaStringObjectInspector;
    }

    @Override
    public Object evaluate(GenericUDF.DeferredObject[] arguments) throws HiveException {
        Object variantObj = arguments[0].get();
        if (variantObj == null) {
            return null;
        }
        Variant variant = Variant.from((List)this.inputOI.getStructFieldsDataAsList(variantObj));
        return variant.toJson((ZoneId)ZoneOffset.UTC);
    }

    @Override
    public String getDisplayString(String[] children) {
        return "to_json(" + children[0] + ")";
    }
}

