/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.ql.QueryDisplay;

public class QueryInfo {
    private final String userName;
    private final String executionEngine;
    private final Long beginTime;
    private final String sessionId;
    private final String operationId;
    private Long runtime;
    private Long endTime;
    private String state;
    private QueryDisplay queryDisplay;
    private String operationLogLocation;

    public QueryInfo(String state, String userName, String executionEngine, String sessionId, String operationId) {
        this.state = state;
        this.userName = userName;
        this.executionEngine = executionEngine;
        this.beginTime = System.currentTimeMillis();
        this.sessionId = sessionId;
        this.operationId = operationId;
    }

    public static QueryInfo getFromConf(HiveConf conf) {
        return new QueryInfo("INITIALIZED", conf.get("hive.driver.default.user.name"), conf.getVar(HiveConf.ConfVars.HIVE_EXECUTION_ENGINE), HiveConf.getVar((Configuration)conf, (HiveConf.ConfVars)HiveConf.ConfVars.HIVE_SESSION_ID), conf.get("hive.driver.default.operation.id"));
    }

    public synchronized long getElapsedTime() {
        if (this.isRunning()) {
            return System.currentTimeMillis() - this.beginTime;
        }
        return this.endTime - this.beginTime;
    }

    public synchronized boolean isRunning() {
        return this.endTime == null;
    }

    public synchronized QueryDisplay getQueryDisplay() {
        return this.queryDisplay;
    }

    public synchronized void setQueryDisplay(QueryDisplay queryDisplay) {
        this.queryDisplay = queryDisplay;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getExecutionEngine() {
        return this.executionEngine;
    }

    public synchronized String getState() {
        return this.state;
    }

    public long getBeginTime() {
        return this.beginTime;
    }

    public synchronized Long getEndTime() {
        return this.endTime;
    }

    public synchronized void updateState(String state) {
        this.state = state;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public synchronized void setEndTime() {
        this.endTime = System.currentTimeMillis();
    }

    public synchronized void setRuntime(long runtime) {
        this.runtime = runtime;
    }

    public synchronized Long getRuntime() {
        return this.runtime;
    }

    public String getOperationLogLocation() {
        return this.operationLogLocation;
    }

    public void setOperationLogLocation(String operationLogLocation) {
        this.operationLogLocation = operationLogLocation;
    }
}

