/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hive.ql;

import java.io.DataInput;
import org.apache.hadoop.hive.conf.HiveConf;
import org.apache.hadoop.hive.metastore.api.Schema;
import org.apache.hadoop.hive.metastore.api.TxnType;
import org.apache.hadoop.hive.ql.HookRunner;
import org.apache.hadoop.hive.ql.QueryDisplay;
import org.apache.hadoop.hive.ql.QueryInfo;
import org.apache.hadoop.hive.ql.QueryPlan;
import org.apache.hadoop.hive.ql.QueryProperties;
import org.apache.hadoop.hive.ql.QueryState;
import org.apache.hadoop.hive.ql.cache.results.CacheUsage;
import org.apache.hadoop.hive.ql.cache.results.QueryResultsCache;
import org.apache.hadoop.hive.ql.exec.FetchTask;
import org.apache.hadoop.hive.ql.exec.Utilities;
import org.apache.hadoop.hive.ql.exec.tez.TezRuntimeContext;
import org.apache.hadoop.hive.ql.exec.tez.TezTask;
import org.apache.hadoop.hive.ql.lockmgr.HiveTxnManager;
import org.apache.hadoop.hive.ql.plan.mapper.StatsSource;

public class DriverContext {
    public static final String DEFAULT_USER_NAME_PROP = "hive.driver.default.user.name";
    public static final String DEFAULT_OPERATION_ID_PROP = "hive.driver.default.operation.id";
    private final QueryDisplay queryDisplay = new QueryDisplay();
    private final QueryState queryState;
    private final QueryInfo queryInfo;
    private final HiveConf conf;
    private final HookRunner hookRunner;
    private final HiveTxnManager initTxnManager;
    private QueryPlan plan;
    private Schema schema;
    private FetchTask fetchTask;
    private HiveTxnManager txnManager;
    private TxnType txnType = TxnType.DEFAULT;
    private boolean outdatedTxn;
    private StatsSource statsSource;
    private boolean validTxnListsGenerated;
    private CacheUsage cacheUsage;
    private QueryResultsCache.CacheEntry usedCacheEntry;
    private boolean retrial = false;
    private DataInput resStream;
    private String operationId;
    private String queryErrorMessage;
    private TezRuntimeContext runtimeContext;
    private QueryProperties queryProperties;
    private String explainPlan;

    public DriverContext(QueryState queryState, QueryInfo queryInfo, HookRunner hookRunner, HiveTxnManager initTxnManager) {
        this.queryState = queryState;
        this.queryInfo = queryInfo;
        this.conf = queryState.getConf();
        this.hookRunner = hookRunner;
        this.initTxnManager = initTxnManager;
    }

    public QueryDisplay getQueryDisplay() {
        return this.queryDisplay;
    }

    public String getQueryId() {
        return this.queryDisplay.getQueryId();
    }

    public String getQueryString() {
        return this.queryDisplay.getQueryString();
    }

    public QueryState getQueryState() {
        return this.queryState;
    }

    public QueryInfo getQueryInfo() {
        return this.queryInfo;
    }

    public HiveConf getConf() {
        return this.conf;
    }

    public HookRunner getHookRunner() {
        return this.hookRunner;
    }

    public HiveTxnManager getInitTxnManager() {
        return this.initTxnManager;
    }

    public QueryPlan getPlan() {
        return this.plan;
    }

    public void setPlan(QueryPlan plan) {
        this.plan = plan;
        if (plan != null) {
            this.runtimeContext = Utilities.getFirstTezTask(plan.getRootTasks()).map(TezTask::getRuntimeContext).orElse(null);
            this.queryProperties = plan.getQueryProperties();
        }
    }

    public QueryProperties.QueryType getQueryType() {
        return this.queryProperties == null ? null : this.queryProperties.getQueryType();
    }

    public TezRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public QueryProperties getQueryProperties() {
        return this.queryProperties;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public void setSchema(Schema schema) {
        this.schema = schema;
    }

    public FetchTask getFetchTask() {
        return this.fetchTask;
    }

    public void setFetchTask(FetchTask fetchTask) {
        this.fetchTask = fetchTask;
    }

    public HiveTxnManager getTxnManager() {
        return this.txnManager;
    }

    public void setTxnManager(HiveTxnManager txnManager) {
        this.txnManager = txnManager;
    }

    public TxnType getTxnType() {
        return this.txnType;
    }

    public void setTxnType(TxnType txnType) {
        this.txnType = txnType;
    }

    public boolean isOutdatedTxn() {
        return this.outdatedTxn;
    }

    public void setOutdatedTxn(boolean outdated) {
        this.outdatedTxn = outdated;
    }

    public StatsSource getStatsSource() {
        return this.statsSource;
    }

    public void setStatsSource(StatsSource statsSource) {
        this.statsSource = statsSource;
    }

    public boolean isValidTxnListsGenerated() {
        return this.validTxnListsGenerated;
    }

    public void setValidTxnListsGenerated(boolean validTxnListsGenerated) {
        this.validTxnListsGenerated = validTxnListsGenerated;
    }

    public CacheUsage getCacheUsage() {
        return this.cacheUsage;
    }

    public void setCacheUsage(CacheUsage cacheUsage) {
        this.cacheUsage = cacheUsage;
    }

    public QueryResultsCache.CacheEntry getUsedCacheEntry() {
        return this.usedCacheEntry;
    }

    public void setUsedCacheEntry(QueryResultsCache.CacheEntry usedCacheEntry) {
        this.usedCacheEntry = usedCacheEntry;
    }

    public boolean isRetrial() {
        return this.retrial;
    }

    public void setRetrial(boolean retrial) {
        this.retrial = retrial;
    }

    public DataInput getResStream() {
        return this.resStream;
    }

    public void setResStream(DataInput resStream) {
        this.resStream = resStream;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public void setOperationId(String operationId) {
        this.operationId = operationId;
    }

    public String getQueryErrorMessage() {
        return this.queryErrorMessage;
    }

    public void setQueryErrorMessage(String queryErrorMessage) {
        this.queryErrorMessage = queryErrorMessage;
    }

    public long getQueryStartTime() {
        return this.getQueryInfo() != null ? this.getQueryInfo().getBeginTime() : this.getQueryDisplay().getQueryStartTime();
    }

    public void setExplainPlan(String explainPlan) {
        this.explainPlan = explainPlan;
    }

    public String getExplainPlan() {
        return this.explainPlan;
    }
}

