/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.MemoryCompactionPolicy;
import org.apache.hadoop.hbase.exceptions.IllegalArgumentIOException;
import org.apache.hadoop.hbase.regionserver.AdaptiveMemStoreCompactionStrategy;
import org.apache.hadoop.hbase.regionserver.BasicMemStoreCompactionStrategy;
import org.apache.hadoop.hbase.regionserver.CompactingMemStore;
import org.apache.hadoop.hbase.regionserver.EagerMemStoreCompactionStrategy;
import org.apache.hadoop.hbase.regionserver.HStore;
import org.apache.hadoop.hbase.regionserver.ImmutableSegment;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactionStrategy;
import org.apache.hadoop.hbase.regionserver.MemStoreCompactorSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreMergerSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.MemStoreSegmentsIterator;
import org.apache.hadoop.hbase.regionserver.RegionCoprocessorHost;
import org.apache.hadoop.hbase.regionserver.Segment;
import org.apache.hadoop.hbase.regionserver.SegmentFactory;
import org.apache.hadoop.hbase.regionserver.VersionedSegmentsList;
import org.apache.hadoop.hbase.util.ClassSize;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class MemStoreCompactor {
    public static final long DEEP_OVERHEAD = ClassSize.align(ClassSize.OBJECT + 4 * ClassSize.REFERENCE + 4 + ClassSize.ATOMIC_BOOLEAN);
    private static final Logger LOG = LoggerFactory.getLogger(MemStoreCompactor.class);
    private CompactingMemStore compactingMemStore;
    private VersionedSegmentsList versionedList;
    private final AtomicBoolean isInterrupted = new AtomicBoolean(false);
    private final int compactionKVMax;
    private MemStoreCompactionStrategy strategy;

    public MemStoreCompactor(CompactingMemStore compactingMemStore, MemoryCompactionPolicy compactionPolicy) throws IllegalArgumentIOException {
        this.compactingMemStore = compactingMemStore;
        this.compactionKVMax = compactingMemStore.getConfiguration().getInt("hbase.hstore.compaction.kv.max", 10);
        this.initiateCompactionStrategy(compactionPolicy, compactingMemStore.getConfiguration(), compactingMemStore.getFamilyName());
    }

    public String toString() {
        return this.strategy + ", compactionCellMax=" + this.compactionKVMax;
    }

    public boolean start() throws IOException {
        if (!this.compactingMemStore.hasImmutableSegments()) {
            return false;
        }
        this.versionedList = this.compactingMemStore.getImmutableSegments();
        LOG.trace("Speculative compaction starting on {}/{}", (Object)this.compactingMemStore.getStore().getHRegion().getRegionInfo().getEncodedName(), (Object)this.compactingMemStore.getStore().getColumnFamilyName());
        HStore store = this.compactingMemStore.getStore();
        RegionCoprocessorHost cpHost = store.getCoprocessorHost();
        if (cpHost != null) {
            cpHost.preMemStoreCompaction(store);
        }
        try {
            this.doCompaction();
        }
        finally {
            if (cpHost != null) {
                cpHost.postMemStoreCompaction(store);
            }
        }
        return true;
    }

    public void stop() {
        this.isInterrupted.compareAndSet(false, true);
    }

    public void resetStats() {
        this.strategy.resetStats();
    }

    private void releaseResources() {
        this.isInterrupted.set(false);
        this.versionedList = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doCompaction() {
        Segment result = null;
        boolean resultSwapped = false;
        MemStoreCompactionStrategy.Action nextStep = this.strategy.getAction(this.versionedList);
        boolean merge = nextStep == MemStoreCompactionStrategy.Action.MERGE || nextStep == MemStoreCompactionStrategy.Action.MERGE_COUNT_UNIQUE_KEYS;
        try {
            if (this.isInterrupted.get()) {
                return;
            }
            if (nextStep == MemStoreCompactionStrategy.Action.NOOP) {
                return;
            }
            if (nextStep == MemStoreCompactionStrategy.Action.FLATTEN || nextStep == MemStoreCompactionStrategy.Action.FLATTEN_COUNT_UNIQUE_KEYS) {
                this.compactingMemStore.flattenOneSegment(this.versionedList.getVersion(), nextStep);
                return;
            }
            if (!this.isInterrupted.get()) {
                result = this.createSubstitution(nextStep);
            }
            if (!this.isInterrupted.get() && (resultSwapped = this.compactingMemStore.swapCompactedSegments(this.versionedList, (ImmutableSegment)result, merge))) {
                this.strategy.updateStats(result);
                this.compactingMemStore.updateLowestUnflushedSequenceIdInWAL(true);
            }
        }
        catch (IOException e) {
            LOG.trace("Interrupting in-memory compaction for store={}", (Object)this.compactingMemStore.getFamilyName());
            Thread.currentThread().interrupt();
        }
        finally {
            if (!merge && result != null && !resultSwapped) {
                result.close();
            }
            this.releaseResources();
            this.compactingMemStore.setInMemoryCompactionCompleted();
        }
    }

    private ImmutableSegment createSubstitution(MemStoreCompactionStrategy.Action action) throws IOException {
        ImmutableSegment result = null;
        MemStoreSegmentsIterator iterator = null;
        List<ImmutableSegment> segments = this.versionedList.getStoreSegments();
        for (ImmutableSegment s2 : segments) {
            s2.waitForUpdates();
        }
        switch (action) {
            case COMPACT: {
                iterator = new MemStoreCompactorSegmentsIterator(segments, this.compactingMemStore.getComparator(), this.compactionKVMax, this.compactingMemStore.getStore());
                result = SegmentFactory.instance().createImmutableSegmentByCompaction(this.compactingMemStore.getConfiguration(), this.compactingMemStore.getComparator(), iterator, this.versionedList.getNumOfCells(), this.compactingMemStore.getIndexType(), action);
                iterator.close();
                break;
            }
            case MERGE: 
            case MERGE_COUNT_UNIQUE_KEYS: {
                iterator = new MemStoreMergerSegmentsIterator(segments, this.compactingMemStore.getComparator(), this.compactionKVMax);
                result = SegmentFactory.instance().createImmutableSegmentByMerge(this.compactingMemStore.getConfiguration(), this.compactingMemStore.getComparator(), iterator, this.versionedList.getNumOfCells(), segments, this.compactingMemStore.getIndexType(), action);
                iterator.close();
                break;
            }
            default: {
                throw new RuntimeException("Unknown action " + (Object)((Object)action));
            }
        }
        return result;
    }

    void initiateCompactionStrategy(MemoryCompactionPolicy compType, Configuration configuration, String cfName) throws IllegalArgumentIOException {
        assert (compType != MemoryCompactionPolicy.NONE);
        switch (compType) {
            case BASIC: {
                this.strategy = new BasicMemStoreCompactionStrategy(configuration, cfName);
                break;
            }
            case EAGER: {
                this.strategy = new EagerMemStoreCompactionStrategy(configuration, cfName);
                break;
            }
            case ADAPTIVE: {
                this.strategy = new AdaptiveMemStoreCompactionStrategy(configuration, cfName);
                break;
            }
            default: {
                throw new IllegalArgumentIOException("Unknown memory compaction type " + (Object)((Object)compType));
            }
        }
    }
}

