/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.utils;

import java.io.Closeable;
import java.io.EOFException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.List;

public interface IntIterator
extends Closeable {
    public int next() throws IOException;

    public static int[] toInts(IntIterator input) {
        return IntIterator.toIntList(input).stream().mapToInt(Integer::intValue).toArray();
    }

    public static List<Integer> toIntList(IntIterator input) {
        ArrayList<Integer> ints = new ArrayList<Integer>();
        try {
            IntIterator iterator = input;
            Throwable throwable = null;
            try {
                try {
                    while (true) {
                        ints.add(iterator.next());
                    }
                }
                catch (EOFException ignored) {
                    if (iterator != null) {
                        if (throwable != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        } else {
                            iterator.close();
                        }
                    }
                }
            }
            catch (Throwable throwable3) {
                try {
                    throwable = throwable3;
                    throw throwable3;
                }
                catch (Throwable throwable4) {
                    if (iterator != null) {
                        if (throwable != null) {
                            try {
                                iterator.close();
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                        } else {
                            iterator.close();
                        }
                    }
                    throw throwable4;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        return ints;
    }

    public static IntIterator create(final int[] ints) {
        return new IntIterator(){
            int pos = -1;

            @Override
            public int next() throws EOFException {
                if (this.pos >= ints.length - 1) {
                    throw new EOFException();
                }
                return ints[++this.pos];
            }

            @Override
            public void close() {
            }
        };
    }
}

