/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ranger.plugin.conditionevaluator;

import org.apache.commons.collections.CollectionUtils;
import org.apache.ranger.plugin.conditionevaluator.RangerAbstractConditionEvaluator;
import org.apache.ranger.plugin.policyengine.RangerAccessRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RangerAccessedFromClusterCondition
extends RangerAbstractConditionEvaluator {
    private static final Logger LOG = LoggerFactory.getLogger(RangerAccessedFromClusterCondition.class);
    private boolean isAlwaysTrue = false;

    @Override
    public void init() {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAccessedFromClusterCondition.init(" + this.condition + ")");
        }
        super.init();
        this.isAlwaysTrue = CollectionUtils.isEmpty(this.condition.getValues());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAccessedFromClusterCondition.init(" + this.condition + ")");
        }
    }

    @Override
    public boolean isMatched(RangerAccessRequest request) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("==> RangerAccessedFromClusterCondition.isMatched(" + this.condition + ")");
        }
        boolean ret = this.isAlwaysTrue || request.getClusterName() == null ? this.isAlwaysTrue : this.condition.getValues().contains(request.getClusterName());
        if (LOG.isDebugEnabled()) {
            LOG.debug("<== RangerAccessedFromClusterCondition.isMatched(" + this.condition + "): " + ret);
        }
        return ret;
    }
}

