/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.partition.file;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.paimon.fs.FileIO;
import org.apache.paimon.fs.Path;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonGetter;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import org.apache.paimon.shade.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.paimon.utils.JsonSerdeUtil;

@JsonIgnoreProperties(ignoreUnknown=true)
public class SuccessFile {
    private static final String FIELD_CREATION_TIME = "creationTime";
    private static final String FIELD_MODIFICATION_TIME = "modificationTime";
    @JsonProperty(value="creationTime")
    private final long creationTime;
    @JsonProperty(value="modificationTime")
    private final long modificationTime;

    @JsonCreator
    public SuccessFile(@JsonProperty(value="creationTime") long creationTime, @JsonProperty(value="modificationTime") long modificationTime) {
        this.creationTime = creationTime;
        this.modificationTime = modificationTime;
    }

    @JsonGetter(value="creationTime")
    public long creationTime() {
        return this.creationTime;
    }

    @JsonGetter(value="modificationTime")
    public long modificationTime() {
        return this.modificationTime;
    }

    public SuccessFile updateModificationTime(long modificationTime) {
        return new SuccessFile(this.creationTime, modificationTime);
    }

    public String toJson() {
        return JsonSerdeUtil.toJson((Object)this);
    }

    public static SuccessFile fromJson(String json) {
        return (SuccessFile)JsonSerdeUtil.fromJson((String)json, SuccessFile.class);
    }

    @Nullable
    public static SuccessFile safelyFromPath(FileIO fileIO, Path path) throws IOException {
        try {
            String json = fileIO.readFileUtf8(path);
            return SuccessFile.fromJson(json);
        }
        catch (FileNotFoundException e) {
            return null;
        }
    }

    public static SuccessFile fromPath(FileIO fileIO, Path path) throws IOException {
        String json = fileIO.readFileUtf8(path);
        return SuccessFile.fromJson(json);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SuccessFile that = (SuccessFile)o;
        return this.creationTime == that.creationTime && this.modificationTime == that.modificationTime;
    }

    public int hashCode() {
        return Objects.hash(this.creationTime, this.modificationTime);
    }
}

