/*
 * Decompiled with CFR 0.152.
 */
package org.apache.paimon.mergetree.localmerge;

import java.io.IOException;
import java.util.Comparator;
import java.util.function.Consumer;
import org.apache.paimon.KeyValue;
import org.apache.paimon.codegen.RecordComparator;
import org.apache.paimon.data.BinaryRow;
import org.apache.paimon.data.InternalRow;
import org.apache.paimon.mergetree.SortBufferWriteBuffer;
import org.apache.paimon.mergetree.compact.MergeFunction;
import org.apache.paimon.mergetree.localmerge.LocalMerger;
import org.apache.paimon.types.RowKind;

public class SortBufferLocalMerger
implements LocalMerger {
    private final SortBufferWriteBuffer sortBuffer;
    private final RecordComparator keyComparator;
    private final MergeFunction<KeyValue> mergeFunction;
    private long recordCount;

    public SortBufferLocalMerger(SortBufferWriteBuffer sortBuffer, RecordComparator keyComparator, MergeFunction<KeyValue> mergeFunction) {
        this.sortBuffer = sortBuffer;
        this.keyComparator = keyComparator;
        this.mergeFunction = mergeFunction;
        this.recordCount = 0L;
    }

    @Override
    public boolean put(RowKind rowKind, BinaryRow key, InternalRow value) throws IOException {
        return this.sortBuffer.put(this.recordCount++, rowKind, (InternalRow)key, value);
    }

    @Override
    public int size() {
        return this.sortBuffer.size();
    }

    @Override
    public void forEach(Consumer<InternalRow> consumer) throws IOException {
        this.sortBuffer.forEach((Comparator<InternalRow>)this.keyComparator, this.mergeFunction, null, kv -> {
            InternalRow row = kv.value();
            row.setRowKind(kv.valueKind());
            consumer.accept(row);
        });
    }

    @Override
    public void clear() {
        this.sortBuffer.clear();
    }
}

