/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gravitino.cli.commands;

import java.util.Map;
import org.apache.gravitino.cli.CommandContext;
import org.apache.gravitino.cli.commands.Command;
import org.apache.gravitino.client.GravitinoAdminClient;
import org.apache.gravitino.exceptions.MetalakeAlreadyExistsException;

public class CreateMetalake
extends Command {
    protected final String metalake;
    protected final String comment;

    public CreateMetalake(CommandContext context, String metalake, String comment) {
        super(context);
        this.metalake = metalake;
        this.comment = comment;
    }

    @Override
    public void handle() {
        try {
            GravitinoAdminClient client = this.buildAdminClient();
            client.createMetalake(this.metalake, this.comment, (Map)null);
        }
        catch (MetalakeAlreadyExistsException err) {
            this.exitWithError("Metalake already exists.");
        }
        catch (Exception exp) {
            this.exitWithError(exp.getMessage());
        }
        this.printInformation(this.metalake + " created");
    }
}

