/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.service.paxos;

import java.io.IOException;
import org.apache.cassandra.db.TypeSizes;
import org.apache.cassandra.io.IVersionedSerializer;
import org.apache.cassandra.io.util.DataInputPlus;
import org.apache.cassandra.io.util.DataOutputPlus;
import org.apache.cassandra.service.paxos.Commit;

public class PrepareResponse {
    public static final PrepareResponseSerializer serializer = new PrepareResponseSerializer();
    public final boolean promised;
    public final Commit inProgressCommit;
    public final Commit mostRecentCommit;

    public PrepareResponse(boolean promised, Commit inProgressCommit, Commit mostRecentCommit) {
        assert (inProgressCommit.update.partitionKey().equals(mostRecentCommit.update.partitionKey()));
        assert (inProgressCommit.update.metadata().id.equals(mostRecentCommit.update.metadata().id));
        this.promised = promised;
        this.mostRecentCommit = mostRecentCommit;
        this.inProgressCommit = inProgressCommit;
    }

    public String toString() {
        return String.format("PrepareResponse(%s, %s, %s)", this.promised, this.mostRecentCommit, this.inProgressCommit);
    }

    public static class PrepareResponseSerializer
    implements IVersionedSerializer<PrepareResponse> {
        @Override
        public void serialize(PrepareResponse response, DataOutputPlus out, int version) throws IOException {
            out.writeBoolean(response.promised);
            Commit.serializer.serialize(response.inProgressCommit, out, version);
            Commit.serializer.serialize(response.mostRecentCommit, out, version);
        }

        @Override
        public PrepareResponse deserialize(DataInputPlus in, int version) throws IOException {
            boolean success = in.readBoolean();
            Commit inProgress = Commit.serializer.deserialize(in, version);
            Commit mostRecent = Commit.serializer.deserialize(in, version);
            return new PrepareResponse(success, inProgress, mostRecent);
        }

        @Override
        public long serializedSize(PrepareResponse response, int version) {
            return (long)TypeSizes.sizeof(response.promised) + Commit.serializer.serializedSize(response.inProgressCommit, version) + Commit.serializer.serializedSize(response.mostRecentCommit, version);
        }
    }
}

