/*
 * Decompiled with CFR 0.152.
 */
package org.apache.trevni;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.trevni.ColumnDescriptor;
import org.apache.trevni.ColumnFileMetaData;
import org.apache.trevni.ColumnFileWriter;
import org.apache.trevni.ColumnMetaData;
import org.apache.trevni.ColumnValues;
import org.apache.trevni.Input;
import org.apache.trevni.InputBuffer;
import org.apache.trevni.InputFile;
import org.apache.trevni.TrevniRuntimeException;

public class ColumnFileReader
implements Closeable {
    private Input file;
    private long rowCount;
    private int columnCount;
    private ColumnFileMetaData metaData;
    private ColumnDescriptor[] columns;
    private Map<String, ColumnDescriptor> columnsByName;

    public ColumnFileReader(File file) throws IOException {
        this(new InputFile(file));
    }

    public ColumnFileReader(Input file) throws IOException {
        this.file = file;
        this.readHeader();
    }

    public long getRowCount() {
        return this.rowCount;
    }

    public long getColumnCount() {
        return this.columnCount;
    }

    public ColumnFileMetaData getMetaData() {
        return this.metaData;
    }

    public ColumnMetaData[] getColumnMetaData() {
        ColumnMetaData[] result = new ColumnMetaData[this.columnCount];
        for (int i = 0; i < this.columnCount; ++i) {
            result[i] = this.columns[i].metaData;
        }
        return result;
    }

    public List<ColumnMetaData> getRoots() {
        ArrayList<ColumnMetaData> result = new ArrayList<ColumnMetaData>();
        for (int i = 0; i < this.columnCount; ++i) {
            if (this.columns[i].metaData.getParent() != null) continue;
            result.add(this.columns[i].metaData);
        }
        return result;
    }

    public ColumnMetaData getColumnMetaData(int number) {
        return this.columns[number].metaData;
    }

    public ColumnMetaData getColumnMetaData(String name) {
        return this.getColumn((String)name).metaData;
    }

    private <T extends Comparable> ColumnDescriptor<T> getColumn(String name) {
        ColumnDescriptor column = this.columnsByName.get(name);
        if (column == null) {
            throw new TrevniRuntimeException("No column named: " + name);
        }
        return column;
    }

    private void readHeader() throws IOException {
        InputBuffer in = new InputBuffer(this.file, 0L);
        this.readMagic(in);
        this.rowCount = in.readFixed64();
        this.columnCount = in.readFixed32();
        this.metaData = ColumnFileMetaData.read(in);
        this.columnsByName = new HashMap<String, ColumnDescriptor>(this.columnCount);
        this.columns = new ColumnDescriptor[this.columnCount];
        this.readColumnMetaData(in);
        this.readColumnStarts(in);
    }

    private void readMagic(InputBuffer in) throws IOException {
        byte[] magic = new byte[ColumnFileWriter.MAGIC.length];
        try {
            in.readFully(magic);
        }
        catch (IOException e) {
            throw new IOException("Not a data file.");
        }
        if (!Arrays.equals(ColumnFileWriter.MAGIC, magic) && Arrays.equals(ColumnFileWriter.MAGIC_1, magic) && Arrays.equals(ColumnFileWriter.MAGIC_0, magic)) {
            throw new IOException("Not a data file.");
        }
    }

    private void readColumnMetaData(InputBuffer in) throws IOException {
        for (int i = 0; i < this.columnCount; ++i) {
            ColumnDescriptor column;
            ColumnMetaData meta = ColumnMetaData.read(in, this);
            meta.setDefaults(this.metaData);
            this.columns[i] = column = new ColumnDescriptor(this.file, meta);
            meta.setNumber(i);
            this.columnsByName.put(meta.getName(), column);
        }
    }

    private void readColumnStarts(InputBuffer in) throws IOException {
        for (int i = 0; i < this.columnCount; ++i) {
            this.columns[i].start = in.readFixed64();
        }
    }

    public <T extends Comparable> ColumnValues<T> getValues(String columnName) throws IOException {
        return new ColumnValues(this.getColumn(columnName));
    }

    public <T extends Comparable> ColumnValues<T> getValues(int column) throws IOException {
        return new ColumnValues(this.columns[column]);
    }

    @Override
    public void close() throws IOException {
        this.file.close();
    }
}

